/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.File;
import java.lang.reflect.Type;

public class GsonFileFactory
implements JsonDeserializer<File>,
JsonSerializer<File> {
    private boolean failOnUnknownProperties;

    public GsonFileFactory() {
        this(false);
    }

    public GsonFileFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public File deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("favorites") && !jsonObject.get("favorites").isJsonArray()) {
            jsonObject.remove("favorites");
        }
        if (jsonObject.has("channels") && !jsonObject.get("channels").isJsonArray()) {
            jsonObject.remove("channels");
        }
        if (jsonObject.has("ims") && !jsonObject.get("ims").isJsonArray()) {
            jsonObject.remove("ims");
        }
        if (jsonObject.has("groups") && !jsonObject.get("groups").isJsonArray()) {
            jsonObject.remove("groups");
        }
        if (jsonObject.has("shares")) {
            JsonObject shares = jsonObject.get("shares").getAsJsonObject();
            if (shares.has("public")) {
                this.adjustSharesObjects(shares.get("public").getAsJsonObject());
            }
            if (shares.has("private")) {
                this.adjustSharesObjects(shares.get("private").getAsJsonObject());
            }
        }
        return (File)context.deserialize((JsonElement)jsonObject, NormalizedFile.class);
    }

    private void adjustSharesObjects(JsonObject shares) {
        for (String channelId : shares.keySet()) {
            for (JsonElement elem : shares.get(channelId).getAsJsonArray()) {
                JsonObject e = elem.getAsJsonObject();
                if (!e.has("reply_users") || e.get("reply_users").isJsonArray()) continue;
                e.remove("reply_users");
            }
        }
    }

    public JsonElement serialize(File src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    static class NormalizedFile
    extends File {
        NormalizedFile() {
        }
    }
}

