/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scrimage.nio;

import com.sksamuel.scrimage.AwtImage;
import com.sksamuel.scrimage.metadata.ImageMetadata;
import com.sksamuel.scrimage.nio.TwelveMonkeysWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class TiffWriter
extends TwelveMonkeysWriter {
    private final String compressionType;

    public TiffWriter() {
        this.compressionType = null;
    }

    public TiffWriter(String compressionType) {
        this.compressionType = compressionType;
    }

    @Override
    public String format() {
        return "tiff";
    }

    public TiffWriter withCompressionType(String compressionType) {
        return new TiffWriter(compressionType);
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    @Override
    public void write(AwtImage image, ImageMetadata metadata, OutputStream out) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName(this.format()).next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        ImageWriteParam params = writer.getDefaultWriteParam();
        if (this.compressionType != null) {
            params.setCompressionMode(2);
            params.setCompressionType(this.compressionType);
        }
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image.awt(), null, null), params);
        ios.close();
        writer.dispose();
    }
}

