/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util.log;

import com.singlestore.jdbc.util.log.ConsoleLogger;
import com.singlestore.jdbc.util.log.JdkLogger;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Slf4JLogger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public final class Loggers {
    private static Boolean slf4jEnabled;
    private static ConsoleLogger.CONSOLE_LOG_LEVEL consoleLogLevel;
    private static boolean printStackTrace;
    private static int maxPrintStackSizeToLog;
    private static String consoleLogFilepath;
    private static PrintStream filePrintStream;
    public static final String FALLBACK_PROPERTY = "singlestore.logging.fallback";
    public static final String CONSOLE_DEBUG_PROPERTY = "singlestore.logging.fallback.console.debug";
    public static final String TEST_ENABLE_SLF4J = "singlestore.logging.slf4j.enable";
    private static Function<String, ? extends Logger> LOGGER_FACTORY;

    public static Logger getLogger(String name) {
        return LOGGER_FACTORY.apply(name);
    }

    public static Logger getLogger(Class<?> cls) {
        return LOGGER_FACTORY.apply(cls.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLoggerFactoryProperties(String level, String path, boolean printTrace, int maxPrintStackSize) {
        Class<Loggers> clazz = Loggers.class;
        synchronized (Loggers.class) {
            printStackTrace = printTrace;
            maxPrintStackSizeToLog = maxPrintStackSize;
            slf4jEnabled = level == null && path == null;
            consoleLogLevel = ConsoleLogger.CONSOLE_LOG_LEVEL.fromLevelName(level);
            String error = null;
            if (path != null && !path.isBlank() && !path.equals(consoleLogFilepath)) {
                consoleLogFilepath = path;
                try {
                    filePrintStream = new PrintStream(new FileOutputStream(consoleLogFilepath, true), true);
                }
                catch (FileNotFoundException e) {
                    error = String.format("failed to create log file stream, error: %s", e.getMessage());
                }
            }
            Loggers.resetLoggerFactory();
            if (error != null) {
                Loggers.getLogger(Loggers.class).error(error);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    static boolean isFallbackToJdk() {
        return "JDK".equalsIgnoreCase(System.getProperty(FALLBACK_PROPERTY));
    }

    static boolean isSlf4jEnabled() {
        return slf4jEnabled == null ? Boolean.parseBoolean(System.getProperty(TEST_ENABLE_SLF4J, "true")) : slf4jEnabled;
    }

    static ConsoleLogger.CONSOLE_LOG_LEVEL getConsoleLogLevel() {
        if (consoleLogLevel != null) {
            return consoleLogLevel;
        }
        return Boolean.parseBoolean(System.getProperty(CONSOLE_DEBUG_PROPERTY, "false")) ? ConsoleLogger.CONSOLE_LOG_LEVEL.TRACE : ConsoleLogger.CONSOLE_LOG_LEVEL.INFO;
    }

    public static String getConsoleLogFilepath() {
        return consoleLogFilepath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetLoggerFactory() {
        Class<Loggers> clazz = Loggers.class;
        synchronized (Loggers.class) {
            Function<String, Logger> loggerFactory = null;
            try {
                if (Loggers.isSlf4jEnabled()) {
                    Class.forName("org.slf4j.LoggerFactory");
                    loggerFactory = new Slf4JLoggerFactory();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (loggerFactory == null) {
                loggerFactory = Loggers.isFallbackToJdk() ? new JdkLoggerFactory() : new ConsoleLoggerFactory();
            }
            LOGGER_FACTORY = loggerFactory;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        Loggers.resetLoggerFactory();
    }

    private static final class ConsoleLoggerFactory
    implements Function<String, Logger> {
        private static final Map<ConsoleLogger.ConsoleLoggerKey, WeakReference<Logger>> consoleLoggers = new WeakHashMap<ConsoleLogger.ConsoleLoggerKey, WeakReference<Logger>>();

        private ConsoleLoggerFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Logger apply(String name) {
            ConsoleLogger.ConsoleLoggerKey key = new ConsoleLogger.ConsoleLoggerKey(name, Loggers.getConsoleLogLevel(), Loggers.getConsoleLogFilepath(), printStackTrace, maxPrintStackSizeToLog);
            Map<ConsoleLogger.ConsoleLoggerKey, WeakReference<Logger>> map = consoleLoggers;
            synchronized (map) {
                Logger cached;
                WeakReference<Logger> ref = consoleLoggers.get(key);
                Logger logger = cached = ref == null ? null : (Logger)ref.get();
                if (cached == null) {
                    cached = new ConsoleLogger(key, filePrintStream, filePrintStream);
                    consoleLoggers.put(key, new WeakReference<Logger>(cached));
                }
                return cached;
            }
        }
    }

    private static class JdkLoggerFactory
    implements Function<String, Logger> {
        private static final Map<String, WeakReference<Logger>> jdkLoggers = new WeakHashMap<String, WeakReference<Logger>>();

        private JdkLoggerFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Logger apply(String name) {
            Map<String, WeakReference<Logger>> map = jdkLoggers;
            synchronized (map) {
                Logger cached;
                WeakReference<Logger> ref = jdkLoggers.get(name);
                Logger logger = cached = ref == null ? null : (Logger)ref.get();
                if (cached == null) {
                    cached = new JdkLogger(java.util.logging.Logger.getLogger(name), printStackTrace, maxPrintStackSizeToLog);
                    jdkLoggers.put(name, new WeakReference<Logger>(cached));
                }
                return cached;
            }
        }
    }

    private static class Slf4JLoggerFactory
    implements Function<String, Logger> {
        private static final Map<String, WeakReference<Logger>> slf4jLoggers = new WeakHashMap<String, WeakReference<Logger>>();

        private Slf4JLoggerFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Logger apply(String name) {
            Map<String, WeakReference<Logger>> map = slf4jLoggers;
            synchronized (map) {
                Logger cached;
                WeakReference<Logger> ref = slf4jLoggers.get(name);
                Logger logger = cached = ref == null ? null : (Logger)ref.get();
                if (cached == null) {
                    cached = new Slf4JLogger(LoggerFactory.getLogger((String)name), printStackTrace, maxPrintStackSizeToLog);
                    slf4jLoggers.put(name, new WeakReference<Logger>(cached));
                }
                return cached;
            }
        }
    }
}

