/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.browser.keyring;

import com.singlestore.jdbc.plugin.credential.browser.ExpiringCredential;
import com.singlestore.jdbc.plugin.credential.browser.keyring.Keyring;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class WindowsKeyring
implements Keyring {
    private static final int CREDENTIAL_TYPE = 1;
    private static final int CREDENTIAL_PERSIST_TYPE = 2;
    private final Advapi32Lib advapi32 = LibManager.getInstance();
    private final Logger logger = Loggers.getLogger(WindowsKeyring.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExpiringCredential getCredential() {
        PointerByReference pCredential = new PointerByReference();
        try {
            boolean res;
            Advapi32Lib advapi32Lib = this.advapi32;
            synchronized (advapi32Lib) {
                res = this.advapi32.CredReadW("SingleStore JDBC Safe Storage", 1, 0, pCredential);
            }
            if (!res) {
                this.logger.debug("Failed to read from Windows Credential Manager or the key does not exist. Error code: " + Native.getLastError());
                advapi32Lib = null;
                return advapi32Lib;
            }
            WindowsCredential cred = new WindowsCredential(pCredential.getValue());
            if (cred.CredentialBlobSize == 0) {
                ExpiringCredential expiringCredential = null;
                return expiringCredential;
            }
            byte[] credBytes = cred.CredentialBlob.getByteArray(0L, cred.CredentialBlobSize);
            try {
                ExpiringCredential expiringCredential = Keyring.fromBlob(new String(credBytes, StandardCharsets.UTF_16LE));
                return expiringCredential;
            }
            catch (IOException e) {
                this.logger.debug("Error while parsing cached token from the Windows Credential Manager", e);
                ExpiringCredential expiringCredential = null;
                if (pCredential.getValue() != null) {
                    Advapi32Lib advapi32Lib2 = this.advapi32;
                    synchronized (advapi32Lib2) {
                        this.advapi32.CredFree(pCredential.getValue());
                    }
                }
                return expiringCredential;
            }
        }
        finally {
            if (pCredential.getValue() != null) {
                Advapi32Lib advapi32Lib = this.advapi32;
                synchronized (advapi32Lib) {
                    this.advapi32.CredFree(pCredential.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCredential(ExpiringCredential cred) {
        boolean res;
        byte[] credBlob = Keyring.makeBlob(cred).getBytes(StandardCharsets.UTF_16LE);
        Memory credBlobMem = new Memory((long)credBlob.length);
        credBlobMem.write(0L, credBlob, 0, credBlob.length);
        WindowsCredential winCred = new WindowsCredential();
        winCred.Type = 1;
        winCred.TargetName = new WString("SingleStore JDBC Safe Storage");
        winCred.CredentialBlobSize = (int)credBlobMem.size();
        winCred.CredentialBlob = credBlobMem;
        winCred.Persist = 2;
        winCred.UserName = new WString(cred.getCredential().getUser());
        Advapi32Lib advapi32Lib = this.advapi32;
        synchronized (advapi32Lib) {
            res = this.advapi32.CredWriteW(winCred, 0);
        }
        if (!res) {
            this.logger.debug("Could not write to Windows Credential Manager. Error code: " + Native.getLastError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCredential() {
        boolean res;
        Advapi32Lib advapi32Lib = this.advapi32;
        synchronized (advapi32Lib) {
            res = this.advapi32.CredDeleteW("SingleStore JDBC Safe Storage", 1, 0);
        }
        if (!res) {
            this.logger.debug("Could not delete from Windows Credential Manager. Error code: " + Native.getLastError());
        }
    }

    public static class WindowsCredential
    extends Structure {
        public int Flags;
        public int Type;
        public WString TargetName;
        public WString Comment;
        public WinBase.FILETIME LastWritten;
        public int CredentialBlobSize;
        public Pointer CredentialBlob;
        public int Persist;
        public int AttributeCount;
        public Pointer Attributes;
        public WString TargetAlias;
        public WString UserName;

        public WindowsCredential() {
        }

        public WindowsCredential(Pointer ptr) {
            super(ptr);
            this.read();
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("Flags", "Type", "TargetName", "Comment", "LastWritten", "CredentialBlobSize", "CredentialBlob", "Persist", "AttributeCount", "Attributes", "TargetAlias", "UserName");
        }
    }

    private static class LibManager {
        private LibManager() {
        }

        public static Advapi32Lib getInstance() {
            return LazyHolder.INSTANCE;
        }

        private static class LazyHolder {
            private static final Advapi32Lib INSTANCE = (Advapi32Lib)Native.load((String)"advapi32", Advapi32Lib.class, (Map)W32APIOptions.UNICODE_OPTIONS);

            private LazyHolder() {
            }
        }
    }

    static interface Advapi32Lib
    extends StdCallLibrary {
        public boolean CredReadW(String var1, int var2, int var3, PointerByReference var4);

        public boolean CredWriteW(WindowsCredential var1, int var2);

        public boolean CredDeleteW(String var1, int var2, int var3);

        public void CredFree(Pointer var1);
    }
}

