/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.Column;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.plugin.Codec;
import com.singlestore.jdbc.type.Polygon;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;

public class PolygonCodec
implements Codec<Polygon> {
    public static final PolygonCodec INSTANCE = new PolygonCodec();

    @Override
    public String className() {
        return Polygon.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return column.getType() == DataType.CHAR && type.isAssignableFrom(Polygon.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Polygon;
    }

    @Override
    public Polygon decodeText(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal);
    }

    @Override
    public Polygon decodeBinary(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        if (column.getType() == DataType.CHAR) {
            String s = buf.readString(length);
            try {
                return new Polygon(s);
            }
            catch (IllegalArgumentException ex) {
                throw new SQLDataException(String.format("Failed to decode '%s' as Polygon", s));
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Polygon", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("'" + value.toString() + "'").getBytes());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        this.encodeBinaryAsString(encoder, value, maxLength);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

