/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.client;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.socket.impl.PacketWriter;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.plugin.Credential;
import com.singlestore.jdbc.plugin.authentication.standard.NativePasswordPlugin;
import com.singlestore.jdbc.util.VersionFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;

public final class HandshakeResponse
implements ClientMessage {
    private static final String _CLIENT_NAME = "_client_name";
    private static final String _CLIENT_VERSION = "_client_version";
    private static final String _SERVER_HOST = "_server_host";
    private static final String _OS = "_os";
    private static final String _THREAD = "_thread";
    private static final String _JAVA_VENDOR = "_java_vendor";
    private static final String _JAVA_VERSION = "_java_version";
    private final String username;
    private final CharSequence password;
    private final String database;
    private final String connectionAttributes;
    private final String host;
    private final long clientCapabilities;
    private final byte exchangeCharset;
    private final byte[] seed;
    private String authenticationPluginType;

    public HandshakeResponse(Credential credential, String authenticationPluginType, byte[] seed, Configuration conf, String host, long clientCapabilities, byte exchangeCharset) {
        this.authenticationPluginType = authenticationPluginType;
        this.seed = seed;
        this.username = credential.getUser();
        this.password = credential.getPassword();
        this.database = conf.database();
        this.connectionAttributes = conf.connectionAttributes();
        this.host = host;
        this.clientCapabilities = clientCapabilities;
        this.exchangeCharset = exchangeCharset;
    }

    private static void writeStringLengthAscii(Writer encoder, String value) throws IOException {
        byte[] valBytes = value.getBytes(StandardCharsets.US_ASCII);
        encoder.writeLength(valBytes.length);
        encoder.writeBytes(valBytes);
    }

    private static void writeStringLength(Writer encoder, String value) throws IOException {
        byte[] valBytes = value.getBytes(StandardCharsets.UTF_8);
        encoder.writeLength(valBytes.length);
        encoder.writeBytes(valBytes);
    }

    private static void writeConnectAttributes(Writer writer, String connectionAttributes, String host) throws IOException {
        PacketWriter tmpWriter = new PacketWriter(null, 0, 0, null, null);
        tmpWriter.pos(0);
        HandshakeResponse.writeStringLengthAscii(tmpWriter, _CLIENT_NAME);
        HandshakeResponse.writeStringLength(tmpWriter, "SingleStore JDBC");
        HandshakeResponse.writeStringLengthAscii(tmpWriter, _CLIENT_VERSION);
        HandshakeResponse.writeStringLength(tmpWriter, VersionFactory.getInstance().getVersion());
        HandshakeResponse.writeStringLengthAscii(tmpWriter, _SERVER_HOST);
        HandshakeResponse.writeStringLength(tmpWriter, host != null ? host : "");
        HandshakeResponse.writeStringLengthAscii(tmpWriter, _OS);
        HandshakeResponse.writeStringLength(tmpWriter, System.getProperty("os.name"));
        HandshakeResponse.writeStringLengthAscii(tmpWriter, _THREAD);
        HandshakeResponse.writeStringLength(tmpWriter, Long.toString(Thread.currentThread().getId()));
        HandshakeResponse.writeStringLengthAscii(tmpWriter, _JAVA_VENDOR);
        HandshakeResponse.writeStringLength(tmpWriter, System.getProperty("java.vendor"));
        HandshakeResponse.writeStringLengthAscii(tmpWriter, _JAVA_VERSION);
        HandshakeResponse.writeStringLength(tmpWriter, System.getProperty("java.version"));
        if (connectionAttributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(connectionAttributes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int separator = token.indexOf(":");
                if (separator != -1) {
                    HandshakeResponse.writeStringLength(tmpWriter, token.substring(0, separator));
                    HandshakeResponse.writeStringLength(tmpWriter, token.substring(separator + 1));
                    continue;
                }
                HandshakeResponse.writeStringLength(tmpWriter, token);
                HandshakeResponse.writeStringLength(tmpWriter, "");
            }
        }
        writer.writeLength(tmpWriter.pos());
        writer.writeBytes(tmpWriter.buf(), 0, tmpWriter.pos());
    }

    @Override
    public int encode(Writer writer, Context context) throws IOException {
        byte[] authData;
        if ("mysql_clear_password".equals(this.authenticationPluginType)) {
            authData = this.password == null ? new byte[]{} : this.password.toString().getBytes(StandardCharsets.UTF_8);
        } else {
            this.authenticationPluginType = "mysql_native_password";
            authData = NativePasswordPlugin.encryptPassword(this.password, this.seed);
        }
        writer.writeInt((int)this.clientCapabilities);
        writer.writeInt(0x40000000);
        writer.writeByte(this.exchangeCharset);
        writer.writeBytes(new byte[19]);
        writer.writeInt((int)(this.clientCapabilities >> 32));
        writer.writeString(this.username != null ? this.username : System.getProperty("user.name"));
        writer.writeByte(0);
        if ((context.getServerCapabilities() & 0x200000L) != 0L) {
            writer.writeLength(authData.length);
            writer.writeBytes(authData);
        } else if ((context.getServerCapabilities() & 0x8000L) != 0L) {
            writer.writeByte((byte)authData.length);
            writer.writeBytes(authData);
        } else {
            writer.writeBytes(authData);
            writer.writeByte(0);
        }
        if ((this.clientCapabilities & 8L) != 0L) {
            writer.writeString(this.database);
            writer.writeByte(0);
        }
        if ((context.getServerCapabilities() & 0x80000L) != 0L) {
            writer.writeString(this.authenticationPluginType);
            writer.writeByte(0);
        }
        if ((context.getServerCapabilities() & 0x100000L) != 0L) {
            HandshakeResponse.writeConnectAttributes(writer, this.connectionAttributes, this.host);
        }
        writer.flush();
        return 1;
    }
}

