/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.Column;
import com.singlestore.jdbc.codec.RowDecoder;
import com.singlestore.jdbc.plugin.Codec;
import com.singlestore.jdbc.plugin.codec.BooleanCodec;
import com.singlestore.jdbc.plugin.codec.ByteCodec;
import com.singlestore.jdbc.plugin.codec.DoubleCodec;
import com.singlestore.jdbc.plugin.codec.FloatCodec;
import com.singlestore.jdbc.plugin.codec.IntCodec;
import com.singlestore.jdbc.plugin.codec.LongCodec;
import com.singlestore.jdbc.plugin.codec.ShortCodec;
import com.singlestore.jdbc.plugin.codec.StringCodec;
import java.sql.SQLException;
import java.util.Calendar;

public class TextRowDecoder
extends RowDecoder {
    public TextRowDecoder(int columnCount, Column[] columns, Configuration conf) {
        super(columnCount, columns, conf);
    }

    @Override
    public <T> T decode(Codec<T> codec, Calendar cal) throws SQLException {
        return codec.decodeText(this.readBuf, this.length, this.columns[this.index], cal);
    }

    @Override
    public byte decodeByte() throws SQLException {
        return ByteCodec.INSTANCE.decodeTextByte(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public boolean decodeBoolean() throws SQLException {
        return BooleanCodec.INSTANCE.decodeTextBoolean(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public short decodeShort() throws SQLException {
        return ShortCodec.INSTANCE.decodeTextShort(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public int decodeInt() throws SQLException {
        return IntCodec.INSTANCE.decodeTextInt(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public String decodeString() throws SQLException {
        return StringCodec.INSTANCE.decodeText(this.readBuf, this.length, this.columns[this.index], null);
    }

    @Override
    public long decodeLong() throws SQLException {
        return LongCodec.INSTANCE.decodeTextLong(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public float decodeFloat() throws SQLException {
        return FloatCodec.INSTANCE.decodeTextFloat(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public double decodeDouble() throws SQLException {
        return DoubleCodec.INSTANCE.decodeTextDouble(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public boolean wasNull() {
        return this.length == -1;
    }

    @Override
    public void setPosition(int newIndex) {
        short len;
        if (this.index >= newIndex) {
            this.index = 0;
            this.readBuf.pos(0);
        } else {
            ++this.index;
        }
        while (this.index < newIndex) {
            len = this.readBuf.readUnsignedByte();
            if (len < 251) {
                this.readBuf.skip(len);
            } else {
                switch (len) {
                    case 252: {
                        this.readBuf.skip(this.readBuf.readUnsignedShort());
                        break;
                    }
                    case 253: {
                        this.readBuf.skip(this.readBuf.readUnsignedMedium());
                        break;
                    }
                    case 254: {
                        this.readBuf.skip((int)(4L + this.readBuf.readUnsignedInt()));
                        break;
                    }
                }
            }
            ++this.index;
        }
        len = this.readBuf.readUnsignedByte();
        if (len < 251) {
            this.length = len;
            return;
        }
        switch (len) {
            case 251: {
                this.length = -1;
                break;
            }
            case 252: {
                this.length = this.readBuf.readUnsignedShort();
                break;
            }
            case 253: {
                this.length = this.readBuf.readUnsignedMedium();
                break;
            }
            case 254: {
                this.length = (int)this.readBuf.readUnsignedInt();
                this.readBuf.skip(4);
            }
        }
    }
}

