/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.impl;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.Client;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.context.RedoContext;
import com.singlestore.jdbc.client.impl.ReplayClient;
import com.singlestore.jdbc.client.impl.StandardClient;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.export.Prepare;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.message.client.ChangeDbPacket;
import com.singlestore.jdbc.message.client.QueryPacket;
import com.singlestore.jdbc.message.client.RedoableWithPrepareClientMessage;
import com.singlestore.jdbc.util.log.Loggers;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;

public class MultiPrimaryClient
implements Client {
    protected static final ConcurrentMap<HostAddress, Long> denyList = new ConcurrentHashMap<HostAddress, Long>();
    protected final long deniedListTimeout;
    protected final Configuration conf;
    protected boolean closed = false;
    protected final ReentrantLock lock;
    protected Client currentClient;

    public MultiPrimaryClient(Configuration conf, ReentrantLock lock) throws SQLException {
        this.conf = conf;
        this.lock = lock;
        this.deniedListTimeout = Long.parseLong(conf.nonMappedOptions().getProperty("deniedListTimeout", "60000"));
        this.currentClient = this.connectHost(false, false);
    }

    protected Client connectHost(boolean readOnly, boolean failFast) throws SQLException {
        Optional<HostAddress> host;
        int maxRetries;
        SQLNonTransientConnectionException lastSqle = null;
        for (maxRetries = this.conf.retriesAllDown(); (host = this.conf.haMode().getAvailableHost(this.conf.addresses(), denyList, !readOnly)).isPresent() && maxRetries > 0; --maxRetries) {
            try {
                return this.conf.transactionReplay() ? new ReplayClient(this.conf, host.get(), this.lock, false) : new StandardClient(this.conf, host.get(), this.lock, false);
            }
            catch (SQLNonTransientConnectionException sqle) {
                lastSqle = sqle;
                denyList.putIfAbsent(host.get(), System.currentTimeMillis() + this.deniedListTimeout);
                continue;
            }
        }
        if (failFast) {
            throw lastSqle != null ? lastSqle : new SQLNonTransientConnectionException("all hosts are blacklisted");
        }
        if (denyList.entrySet().stream().noneMatch(e -> this.conf.addresses().contains(e.getKey()) && ((HostAddress)e.getKey()).primary != readOnly)) {
            throw new SQLNonTransientConnectionException(String.format("No %s host defined", readOnly ? "replica" : "primary"));
        }
        while (maxRetries > 0) {
            try {
                host = denyList.entrySet().stream().sorted(Map.Entry.comparingByValue()).filter(e -> this.conf.addresses().contains(e.getKey()) && ((HostAddress)e.getKey()).primary != readOnly).findFirst().map(Map.Entry::getKey);
                if (host.isPresent()) {
                    StandardClient client = this.conf.transactionReplay() ? new ReplayClient(this.conf, host.get(), this.lock, false) : new StandardClient(this.conf, host.get(), this.lock, false);
                    denyList.remove(host.get());
                    return client;
                }
                --maxRetries;
            }
            catch (SQLNonTransientConnectionException sqle) {
                lastSqle = sqle;
                host.ifPresent(hostAddress -> denyList.putIfAbsent((HostAddress)hostAddress, System.currentTimeMillis() + this.deniedListTimeout));
                if (--maxRetries <= 0) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw lastSqle;
    }

    protected Client reConnect() throws SQLException {
        denyList.putIfAbsent(this.currentClient.getHostAddress(), System.currentTimeMillis() + this.deniedListTimeout);
        Loggers.getLogger(MultiPrimaryClient.class).info("Connection error on {}", this.currentClient.getHostAddress());
        try {
            Client oldClient = this.currentClient;
            oldClient.getContext().resetPrepareCache();
            this.currentClient = this.connectHost(false, false);
            this.syncNewState(oldClient);
            return oldClient;
        }
        catch (SQLNonTransientConnectionException sqle) {
            this.currentClient = null;
            this.closed = true;
            throw sqle;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void replayIfPossible(Client oldClient, boolean canRedo) throws SQLException {
        if (oldClient == null) return;
        if ((oldClient.getContext().getServerStatus() & 1) > 0) {
            if (!this.conf.transactionReplay()) throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications link failure with %s. In progress transaction was lost", oldClient.getHostAddress()), "25S03");
            this.executeTransactionReplay(oldClient);
            return;
        } else {
            if (canRedo) return;
            throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications link failure with %s", oldClient.getHostAddress()), "25S03");
        }
    }

    protected void executeTransactionReplay(Client oldCli) throws SQLException {
        RedoContext ctx = (RedoContext)oldCli.getContext();
        if (ctx.getTransactionSaver().isDirty()) {
            ctx.getTransactionSaver().clear();
            throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications link failure with %s. In progress transaction was too big to be replayed, and was lost", oldCli.getHostAddress()), "25S03");
        }
        ((ReplayClient)this.currentClient).transactionReplay(ctx.getTransactionSaver());
    }

    public void syncNewState(Client oldCli) throws SQLException {
        Context oldCtx = oldCli.getContext();
        this.currentClient.getExceptionFactory().setConnection(oldCli.getExceptionFactory());
        if ((oldCtx.getStateFlag() & 8) > 0 && (oldCtx.getServerStatus() & 2) != (this.currentClient.getContext().getServerStatus() & 2)) {
            this.currentClient.getContext().addStateFlag(8);
            this.currentClient.execute(new QueryPacket("set autocommit=" + ((oldCtx.getServerStatus() & 2) > 0 ? "true" : "false")), true);
        }
        if ((oldCtx.getStateFlag() & 2) > 0 && !Objects.equals(this.currentClient.getContext().getDatabase(), oldCtx.getDatabase())) {
            this.currentClient.getContext().addStateFlag(2);
            if (oldCtx.getDatabase() != null) {
                this.currentClient.execute(new ChangeDbPacket(oldCtx.getDatabase()), true);
            }
            this.currentClient.getContext().setDatabase(oldCtx.getDatabase());
        }
        if ((oldCtx.getStateFlag() & 1) > 0) {
            this.currentClient.setSocketTimeout(oldCli.getSocketTimeout());
        }
        if ((oldCtx.getStateFlag() & 0x10) > 0 && this.currentClient.getContext().getTransactionIsolationLevel() != oldCtx.getTransactionIsolationLevel()) {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (oldCtx.getTransactionIsolationLevel()) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                }
            }
            this.currentClient.getContext().setTransactionIsolationLevel(oldCtx.getTransactionIsolationLevel());
            this.currentClient.execute(new QueryPacket(query), true);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, boolean canRedo) throws SQLException {
        return this.execute(message, null, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, boolean canRedo) throws SQLException {
        return this.execute(message, stmt, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            return this.currentClient.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        }
        catch (SQLNonTransientConnectionException e) {
            HostAddress hostAddress = this.currentClient.getHostAddress();
            Client oldClient = this.reConnect();
            if (message instanceof QueryPacket && ((QueryPacket)message).isCommit()) {
                throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications failure with %s during a COMMIT statement", hostAddress), "25S03");
            }
            this.replayIfPossible(oldClient, canRedo);
            if (message instanceof RedoableWithPrepareClientMessage) {
                ((RedoableWithPrepareClientMessage)message).rePrepare(this.currentClient);
            }
            return this.currentClient.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        }
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            return this.currentClient.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        }
        catch (SQLException e) {
            if (e instanceof SQLNonTransientConnectionException || e.getCause() != null && e.getCause() instanceof SQLNonTransientConnectionException) {
                Client oldClient = this.reConnect();
                this.replayIfPossible(oldClient, canRedo);
                Arrays.stream(messages).filter(RedoableWithPrepareClientMessage.class::isInstance).map(RedoableWithPrepareClientMessage.class::cast).forEach(rd -> {
                    try {
                        rd.rePrepare(this.currentClient);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                });
                return this.currentClient.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
            }
            throw e;
        }
    }

    @Override
    public void readStreamingResults(List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            this.currentClient.readStreamingResults(completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
        catch (SQLNonTransientConnectionException e) {
            try {
                this.reConnect();
            }
            catch (SQLException e2) {
                throw this.getExceptionFactory().create("Socket error during result streaming", e2.getSQLState(), e2);
            }
            throw this.getExceptionFactory().create("Socket error during result streaming", "HY000", e);
        }
    }

    @Override
    public void closePrepare(Prepare prepare) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            this.currentClient.closePrepare(prepare);
        }
        catch (SQLNonTransientConnectionException e) {
            this.reConnect();
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.currentClient.abort(executor);
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.currentClient.close();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.currentClient.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int milliseconds) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            this.currentClient.setSocketTimeout(milliseconds);
        }
        catch (SQLNonTransientConnectionException e) {
            this.reConnect();
            this.currentClient.setSocketTimeout(milliseconds);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Context getContext() {
        return this.currentClient.getContext();
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.currentClient.getExceptionFactory();
    }

    @Override
    public HostAddress getHostAddress() {
        return this.currentClient.getHostAddress();
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public void reset() {
        this.currentClient.getContext().resetStateFlag();
        this.currentClient.getContext().resetPrepareCache();
    }
}

