/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.server;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.DataType;
import com.singlestore.jdbc.codec.list.BigDecimalCodec;
import com.singlestore.jdbc.codec.list.BigIntegerCodec;
import com.singlestore.jdbc.codec.list.BitSetCodec;
import com.singlestore.jdbc.codec.list.BlobCodec;
import com.singlestore.jdbc.codec.list.ByteArrayCodec;
import com.singlestore.jdbc.codec.list.ByteCodec;
import com.singlestore.jdbc.codec.list.ClobCodec;
import com.singlestore.jdbc.codec.list.DateCodec;
import com.singlestore.jdbc.codec.list.DoubleCodec;
import com.singlestore.jdbc.codec.list.FloatCodec;
import com.singlestore.jdbc.codec.list.IntCodec;
import com.singlestore.jdbc.codec.list.LineStringCodec;
import com.singlestore.jdbc.codec.list.LongCodec;
import com.singlestore.jdbc.codec.list.PointCodec;
import com.singlestore.jdbc.codec.list.PolygonCodec;
import com.singlestore.jdbc.codec.list.ShortCodec;
import com.singlestore.jdbc.codec.list.StringCodec;
import com.singlestore.jdbc.codec.list.TimeCodec;
import com.singlestore.jdbc.codec.list.TimestampCodec;
import com.singlestore.jdbc.message.server.ServerMessage;
import com.singlestore.jdbc.util.CharsetEncodingLength;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ColumnDefinitionPacket
implements ServerMessage {
    private final ReadableByteBuf buf;
    private final int charset;
    private final long length;
    private final DataType dataType;
    private final byte decimals;
    private final int flags;
    private final int[] stringPos;
    private final String extTypeName;
    private boolean useAliasAsName;

    private ColumnDefinitionPacket(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos) {
        this.buf = buf;
        this.charset = charset;
        this.length = length;
        this.dataType = dataType;
        this.decimals = decimals;
        this.flags = flags;
        this.stringPos = stringPos;
        this.extTypeName = null;
    }

    public ColumnDefinitionPacket(ReadableByteBuf buf, boolean extendedInfo) {
        this.stringPos = new int[5];
        this.stringPos[0] = buf.skipIdentifier();
        this.stringPos[1] = buf.skipIdentifier();
        this.stringPos[2] = buf.skipIdentifier();
        this.stringPos[3] = buf.skipIdentifier();
        this.stringPos[4] = buf.skipIdentifier();
        buf.skipIdentifier();
        if (extendedInfo) {
            String tmpTypeName = null;
            if (buf.readByte() != 0) {
                buf.pos(buf.pos() - 1);
                ReadableByteBuf subPacket = buf.readLengthBuffer();
                while (subPacket.readableBytes() > 0) {
                    if (subPacket.readByte() == 0) {
                        tmpTypeName = subPacket.readAscii(subPacket.readLength());
                        continue;
                    }
                    subPacket.skip(subPacket.readLength());
                }
            }
            this.extTypeName = tmpTypeName;
        } else {
            this.extTypeName = null;
        }
        this.buf = buf;
        buf.skip();
        this.charset = buf.readShort();
        this.length = buf.readInt();
        this.dataType = DataType.of(buf.readUnsignedByte());
        this.flags = buf.readUnsignedShort();
        this.decimals = buf.readByte();
    }

    public static ColumnDefinitionPacket create(String name, DataType type) {
        int len;
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] arr = new byte[9 + 2 * nameBytes.length];
        arr[0] = 3;
        arr[1] = 68;
        arr[2] = 69;
        arr[3] = 70;
        int[] stringPos = new int[5];
        stringPos[0] = 4;
        stringPos[1] = 5;
        stringPos[2] = 6;
        int pos = 7;
        for (int i = 0; i < 2; ++i) {
            stringPos[i + 3] = pos;
            arr[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, arr, pos, nameBytes.length);
            pos += nameBytes.length;
        }
        switch (type) {
            case VARCHAR: 
            case VARSTRING: {
                len = 192;
                break;
            }
            case SMALLINT: {
                len = 5;
                break;
            }
            case NULL: {
                len = 0;
                break;
            }
            default: {
                len = 1;
            }
        }
        return new ColumnDefinitionPacket(new ReadableByteBuf(null, arr, arr.length), 33, len, type, 0, 2, stringPos);
    }

    public String getSchema() {
        this.buf.pos(this.stringPos[0]);
        return this.buf.readString(this.buf.readLength());
    }

    public String getTableAlias() {
        this.buf.pos(this.stringPos[1]);
        return this.buf.readString(this.buf.readLength());
    }

    public String getTable() {
        this.buf.pos(this.stringPos[this.useAliasAsName ? 1 : 2]);
        return this.buf.readString(this.buf.readLength());
    }

    public String getColumnAlias() {
        this.buf.pos(this.stringPos[3]);
        return this.buf.readString(this.buf.readLength());
    }

    public String getColumn() {
        this.buf.pos(this.stringPos[4]);
        return this.buf.readString(this.buf.readLength());
    }

    public long getLength() {
        return this.length;
    }

    public DataType getType() {
        return this.dataType;
    }

    public byte getDecimals() {
        if (this.dataType == DataType.DATE) {
            return 0;
        }
        return this.decimals;
    }

    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    public int getDisplaySize() {
        switch (this.dataType) {
            case VARCHAR: 
            case VARSTRING: 
            case JSON: 
            case ENUM: 
            case SET: 
            case STRING: 
            case DATE: {
                Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
                if (maxWidth == null) {
                    return (int)this.length;
                }
                return (int)this.length / maxWidth;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return this.decimals == 0 ? (int)this.length - 7 : (int)this.length;
            }
            case TIME: {
                return this.decimals == 0 ? 10 : 17;
            }
            case FLOAT: {
                return 9;
            }
            case DOUBLE: {
                return 18;
            }
        }
        return (int)this.length;
    }

    public boolean isPrimaryKey() {
        return (this.flags & 2) > 0;
    }

    public boolean isAutoIncrement() {
        return (this.flags & 0x200) > 0;
    }

    public boolean hasDefault() {
        return (this.flags & 0x1000) == 0;
    }

    public boolean isBinary() {
        return this.charset == 63;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getExtTypeName() {
        return this.extTypeName;
    }

    public long getPrecision() {
        switch (this.dataType) {
            case OLDDECIMAL: 
            case DECIMAL: {
                if (this.isSigned()) {
                    return this.length - (long)(this.decimals > 0 ? 2 : 1);
                }
                return this.length - (long)(this.decimals > 0 ? 1 : 0);
            }
            case VARCHAR: 
            case VARSTRING: 
            case JSON: 
            case ENUM: 
            case SET: 
            case STRING: {
                Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
                if (maxWidth == null) {
                    return this.length;
                }
                return this.length / (long)maxWidth.intValue();
            }
            case FLOAT: {
                return 6L;
            }
            case DOUBLE: {
                return 14L;
            }
            case DATE: {
                return 10L;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return this.decimals == 0 ? this.length - 7L : this.length;
            }
            case TIME: {
                return this.decimals == 0 ? 10L : 17L;
            }
        }
        return this.length;
    }

    public int getColumnType(Configuration conf) {
        switch (this.dataType) {
            case TINYINT: {
                if (conf.tinyInt1isBit()) {
                    return -7;
                }
                return this.isSigned() ? -6 : 5;
            }
            case BIT: {
                if (this.length == 1L) {
                    return -7;
                }
                return -3;
            }
            case SMALLINT: {
                return this.isSigned() ? 5 : 4;
            }
            case INTEGER: {
                return this.isSigned() ? 4 : -5;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 8;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return 93;
            }
            case BIGINT: {
                return -5;
            }
            case MEDIUMINT: {
                return 4;
            }
            case DATE: 
            case NEWDATE: {
                return 91;
            }
            case TIME: {
                return 92;
            }
            case YEAR: {
                if (conf.yearIsDateType()) {
                    return 91;
                }
                return 5;
            }
            case VARCHAR: 
            case VARSTRING: 
            case JSON: 
            case ENUM: 
            case SET: 
            case TINYBLOB: 
            case BLOB: {
                return this.isBinary() ? -3 : 12;
            }
            case GEOMETRY: {
                return -3;
            }
            case STRING: {
                return this.isBinary() ? -3 : 1;
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return 3;
            }
            case MEDIUMBLOB: 
            case LONGBLOB: {
                return this.isBinary() ? -4 : -1;
            }
        }
        return 0;
    }

    public Codec<?> getDefaultCodec(Configuration conf) {
        switch (this.dataType) {
            case VARCHAR: 
            case VARSTRING: 
            case JSON: 
            case ENUM: 
            case SET: 
            case STRING: {
                return StringCodec.INSTANCE;
            }
            case TINYINT: {
                return this.isSigned() ? ByteCodec.INSTANCE : ShortCodec.INSTANCE;
            }
            case SMALLINT: {
                return this.isSigned() ? ShortCodec.INSTANCE : IntCodec.INSTANCE;
            }
            case INTEGER: {
                return this.isSigned() ? IntCodec.INSTANCE : LongCodec.INSTANCE;
            }
            case FLOAT: {
                return FloatCodec.INSTANCE;
            }
            case DOUBLE: {
                return DoubleCodec.INSTANCE;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return TimestampCodec.INSTANCE;
            }
            case BIGINT: {
                return this.isSigned() ? LongCodec.INSTANCE : BigIntegerCodec.INSTANCE;
            }
            case MEDIUMINT: {
                return IntCodec.INSTANCE;
            }
            case DATE: 
            case NEWDATE: {
                return DateCodec.INSTANCE;
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return BigDecimalCodec.INSTANCE;
            }
            case GEOMETRY: {
                if (conf.geometryDefaultType() != null && "default".equals(conf.geometryDefaultType())) {
                    switch (this.extTypeName) {
                        case "point": {
                            return PointCodec.INSTANCE;
                        }
                        case "linestring": {
                            return LineStringCodec.INSTANCE;
                        }
                        case "polygon": {
                            return PolygonCodec.INSTANCE;
                        }
                    }
                }
                return ByteArrayCodec.INSTANCE;
            }
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                return this.isBinary() ? BlobCodec.INSTANCE : ClobCodec.INSTANCE;
            }
            case TIME: {
                return TimeCodec.INSTANCE;
            }
            case YEAR: {
                if (conf.yearIsDateType()) {
                    return DateCodec.INSTANCE;
                }
                return ShortCodec.INSTANCE;
            }
            case BIT: {
                return BitSetCodec.INSTANCE;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected datatype %s", new Object[]{this.dataType}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinitionPacket that = (ColumnDefinitionPacket)o;
        return this.charset == that.charset && this.length == that.length && this.dataType == that.dataType && this.decimals == that.decimals && this.flags == that.flags;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.charset, this.length, this.dataType, this.decimals, this.flags});
    }

    public void useAliasAsName() {
        this.useAliasAsName = true;
    }
}

