/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.context;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.PrepareCache;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.message.server.InitialHandshakePacket;
import com.singlestore.jdbc.util.exceptions.ExceptionFactory;

public class BaseContext
implements Context {
    private final long threadId;
    private final long serverCapabilities;
    private final byte[] seed;
    private final boolean eofDeprecated;
    private final boolean skipMeta;
    private final boolean extendedInfo;
    private final Configuration conf;
    private final ExceptionFactory exceptionFactory;
    protected int serverStatus;
    private String database;
    private int transactionIsolationLevel;
    private int warning;
    private final PrepareCache prepareCache;
    private int stateFlag = 0;

    public BaseContext(InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache) {
        this.threadId = handshake.getThreadId();
        this.seed = handshake.getSeed();
        this.serverCapabilities = handshake.getCapabilities();
        this.serverStatus = handshake.getServerStatus();
        this.eofDeprecated = (clientCapabilities & 0x1000000L) > 0L;
        this.skipMeta = (this.serverCapabilities & 0x1000000000L) > 0L;
        this.extendedInfo = (this.serverCapabilities & 0x800000000L) > 0L;
        this.conf = conf;
        this.database = conf.database();
        this.exceptionFactory = exceptionFactory;
        this.prepareCache = prepareCache;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public byte[] getSeed() {
        return this.seed;
    }

    @Override
    public long getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public int getServerStatus() {
        return this.serverStatus;
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public boolean isEofDeprecated() {
        return this.eofDeprecated;
    }

    @Override
    public boolean isExtendedInfo() {
        return this.extendedInfo;
    }

    @Override
    public boolean canSkipMeta() {
        return this.skipMeta;
    }

    @Override
    public int getWarning() {
        return this.warning;
    }

    @Override
    public void setWarning(int warning) {
        this.warning = warning;
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    @Override
    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public PrepareCache getPrepareCache() {
        return this.prepareCache;
    }

    @Override
    public int getStateFlag() {
        return this.stateFlag;
    }

    @Override
    public void resetStateFlag() {
        this.stateFlag = 0;
    }

    @Override
    public void addStateFlag(int state) {
        this.stateFlag |= state;
    }
}

