/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service.apiclient;

import com.silanis.esl.api.model.AuthenticationToken;
import com.silanis.esl.api.model.SenderAuthenticationToken;
import com.silanis.esl.api.model.SessionFields;
import com.silanis.esl.api.model.SignerAuthenticationToken;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.util.Map;

public class AuthenticationTokensApiClient {
    private UrlTemplate template;
    private RestClient restClient;

    public AuthenticationTokensApiClient(RestClient restClient, String apiUrl) {
        this.restClient = restClient;
        this.template = new UrlTemplate(apiUrl);
    }

    public AuthenticationToken createUserAuthenticationToken() {
        String path = this.template.urlFor("/authenticationTokens/user").build();
        try {
            String stringResponse = this.restClient.post(path, "");
            return Serialization.fromJson(stringResponse, AuthenticationToken.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a user authentication token.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a user authentication token.", e);
        }
    }

    public SenderAuthenticationToken createSenderAuthenticationToken(String packageId) {
        String path = this.template.urlFor("/authenticationTokens/sender").build();
        SenderAuthenticationToken payloadObject = new SenderAuthenticationToken();
        payloadObject.setPackageId(packageId);
        try {
            String payload = JacksonUtil.serialize(payloadObject);
            String stringResponse = this.restClient.post(path, payload);
            return Serialization.fromJson(stringResponse, SenderAuthenticationToken.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a sender authentication token.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a sender authentication token.", e);
        }
    }

    public SignerAuthenticationToken createSignerAuthenticationToken(String packageId, String signerId) {
        return this.createSignerAuthenticationToken(packageId, signerId, null);
    }

    public SignerAuthenticationToken createSignerAuthenticationToken(String packageId, String signerId, Map<String, String> fields) {
        String path = this.template.urlFor("/authenticationTokens/signer/multiUse").build();
        SignerAuthenticationToken payloadObject = new SignerAuthenticationToken();
        payloadObject.setPackageId(packageId);
        payloadObject.setSignerId(signerId);
        SessionFields sessionFields = new SessionFields();
        sessionFields.setFields(fields);
        payloadObject.setSessionFields(sessionFields);
        try {
            String payload = JacksonUtil.serialize(payloadObject);
            String stringResponse = this.restClient.post(path, payload);
            return Serialization.fromJson(stringResponse, SignerAuthenticationToken.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a signer authentication token.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a signer authentication token.", e);
        }
    }

    public SignerAuthenticationToken createSignerAuthenticationTokenForSingleUse(String packageId, String signerId, Map<String, String> fields) {
        String path = this.template.urlFor("/authenticationTokens/signer/singleUse").build();
        SignerAuthenticationToken payloadObject = new SignerAuthenticationToken();
        payloadObject.setPackageId(packageId);
        payloadObject.setSignerId(signerId);
        SessionFields sessionFields = new SessionFields();
        sessionFields.setFields(fields);
        payloadObject.setSessionFields(sessionFields);
        try {
            String payload = JacksonUtil.serialize(payloadObject);
            String stringResponse = this.restClient.post(path, payload);
            return Serialization.fromJson(stringResponse, SignerAuthenticationToken.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a signer authentication token for single use.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a signer authentication token for single use.", e);
        }
    }
}

