/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service.apiclient;

import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.ConditionalField;
import com.silanis.esl.api.model.Field;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SignatureId;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.util.List;

public class ApprovalApiClient {
    private UrlTemplate template;
    private RestClient restClient;

    public ApprovalApiClient(RestClient restClient, String apiUrl) {
        this.restClient = restClient;
        this.template = new UrlTemplate(apiUrl);
    }

    public void deleteSignature(String packageId, String documentId, String signatureId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{approvalId}", signatureId).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete signature from document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete signature from document.", e);
        }
    }

    public Approval addSignature(String packageId, String documentId, Approval approval) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals").replace("{packageId}", packageId).replace("{documentId}", documentId).build();
        try {
            String json = Serialization.toJson(approval);
            String stringResponse = this.restClient.post(path, json);
            Approval apiResponse = Serialization.fromJson(stringResponse, Approval.class);
            return apiResponse;
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add signature to document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add signature to document.", e);
        }
    }

    public void modifySignature(String packageId, String documentId, Approval approval) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{approvalId}", approval.getId()).build();
        try {
            String json = Serialization.toJson(approval);
            this.restClient.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not modify signature from document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not modify signature from document.", e);
        }
    }

    public void updateSignatures(String packageId, String documentId, List<Approval> approvalList) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals").replace("{packageId}", packageId).replace("{documentId}", documentId).build();
        try {
            String json = Serialization.toJson(approvalList);
            this.restClient.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update signatures from document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update signatures from document.", e);
        }
    }

    public Approval getSignature(String packageId, String documentId, String approvalId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{approvalId}", approvalId).build();
        try {
            String stringResponse = this.restClient.get(path);
            Approval apiResponse = Serialization.fromJson(stringResponse, Approval.class);
            return apiResponse;
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get signature from document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get signature from document.", e);
        }
    }

    public String addField(PackageId packageId, String documentId, SignatureId signatureId, Field apiField) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}/fields").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).replace("{approvalId}", signatureId.getId()).build();
        try {
            String json = Serialization.toJson(apiField);
            String stringResponse = this.restClient.post(path, json);
            Field apiResponse = Serialization.fromJson(stringResponse, Field.class);
            return apiResponse.getId();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add field to signature.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add field to signature.", e);
        }
    }

    public void updateField(String packageId, String documentId, String signatureId, Field field) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}/fields/{fieldId}").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{approvalId}", signatureId).replace("{fieldId}", field.getId()).build();
        try {
            String json = Serialization.toJson(field);
            this.restClient.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update field from signature.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update field from signature.", e);
        }
    }

    public void updateConditionalField(String packageId, String documentId, String signatureId, ConditionalField field) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}/fields/{fieldId}/conditionalFields").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{approvalId}", signatureId).replace("{fieldId}", field.getId()).build();
        try {
            String json = Serialization.toJson(field);
            this.restClient.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update conditional field from signature.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update conditional field from signature.", e);
        }
    }

    public void deleteField(String packageId, String documentId, String approvalId, String fieldId) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}/fields/{fieldId}").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{approvalId}", approvalId).replace("{fieldId}", fieldId).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete field from signature.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete field from signature.", e);
        }
    }

    public Field getField(String packageId, String documentId, String approvalId, String fieldId) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/approvals/{approvalId}/fields/{fieldId}").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{approvalId}", approvalId).replace("{fieldId}", fieldId).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJson(stringResponse, Field.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get field from signature.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get field from signature.", e);
        }
    }

    public List<Approval> getAllSignableApprovals(String packageId, String documentId, String signerId) {
        List<Approval> approvals;
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/signers/{signerId}/approvals").replace("{packageId}", packageId).replace("{documentId}", documentId).replace("{signerId}", signerId).build();
        try {
            String stringResponse = this.restClient.get(path);
            approvals = Serialization.fromJsonToList(stringResponse, Approval.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get all signable signatures.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get all signable signatures.", e);
        }
        return approvals;
    }
}

