/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service.apiclient;

import com.silanis.esl.api.model.Handover;
import com.silanis.esl.api.model.IdvWorkflowConfiguration;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.AccountFeatureSettings;
import com.silanis.esl.sdk.AccountPackageSettings;
import com.silanis.esl.sdk.AccountSettings;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.AccountFeatureSettingsConverter;
import com.silanis.esl.sdk.internal.converter.AccountPackageSettingsConverter;
import com.silanis.esl.sdk.internal.converter.AccountSettingsConverter;
import java.util.List;

public class AccountConfigClient {
    private UrlTemplate template;
    private RestClient restClient;

    public AccountConfigClient(RestClient restClient, String apiUrl) {
        this.restClient = restClient;
        this.template = new UrlTemplate(apiUrl);
    }

    public Handover getHandoverUrl(String language) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJson(stringResponse, Handover.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get handover url.", e);
        }
    }

    public Handover createHandoverUrl(String language, Handover handover) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            String json = Serialization.toJson(handover);
            String stringResponse = this.restClient.post(path, json);
            return Serialization.fromJson(stringResponse, Handover.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create handover url.", e);
        }
    }

    public Handover updateHandoverUrl(String language, Handover handover) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            String json = Serialization.toJson(handover);
            String stringResponse = this.restClient.put(path, json);
            return Serialization.fromJson(stringResponse, Handover.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update handover url.", e);
        }
    }

    public void deleteHandoverUrl(String language) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete handover url.", e);
        }
    }

    public List<String> createDeclineReasons(String language, List<String> declineReasons) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        String json = Serialization.toJson(declineReasons);
        try {
            String stringResponse = this.restClient.post(path, json);
            return Serialization.fromJsonToList(stringResponse, String.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create decline reasons.", e);
        }
    }

    public List<String> updateDeclineReasons(String language, List<String> declineReasons) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        String json = Serialization.toJson(declineReasons);
        try {
            String stringResponse = this.restClient.put(path, json);
            return Serialization.fromJsonToList(stringResponse, String.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update decline reasons.", e);
        }
    }

    public List<String> getDeclineReasons(String language) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJsonToList(stringResponse, String.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get decline reasons.", e);
        }
    }

    public void deleteDeclineReasons(String language) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete decline reasons.", e);
        }
    }

    public List<IdvWorkflowConfiguration> getIdvWorkflowConfigs() {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJsonToList(stringResponse, IdvWorkflowConfiguration.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get IdvWorkflow Configs.", e);
        }
    }

    public List<IdvWorkflowConfiguration> createIdvWorkflowConfigs(List<IdvWorkflowConfiguration> idvWorkflowConfigurations) {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            String json = Serialization.toJson(idvWorkflowConfigurations);
            String stringResponse = this.restClient.post(path, json);
            return Serialization.fromJsonToList(stringResponse, IdvWorkflowConfiguration.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create IdvWorkflow Configs.", e);
        }
    }

    public List<IdvWorkflowConfiguration> updateIdvWorkflowConfigs(List<IdvWorkflowConfiguration> idvWorkflowConfigurations) {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            String json = Serialization.toJson(idvWorkflowConfigurations);
            String stringResponse = this.restClient.put(path, json);
            return Serialization.fromJsonToList(stringResponse, IdvWorkflowConfiguration.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update IdvWorkflow Configs.", e);
        }
    }

    public void deleteIdvWorkflowConfigs() {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete IdvWorkflow Configs.", e);
        }
    }

    public AccountSettings getAccountSettings() {
        String path = this.template.urlFor("/account/admin/accountSettings").build();
        try {
            String stringResponse = this.restClient.get(path);
            return new AccountSettingsConverter(Serialization.fromJson(stringResponse, com.silanis.esl.api.model.AccountSettings.class)).toSDKAccountSettings();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the account settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the account settings.", e);
        }
    }

    public void saveAccountSettings(AccountSettings accountSettings) {
        String path = this.template.urlFor("/account/admin/accountSettings").build();
        String payload = JacksonUtil.serialize(accountSettings);
        try {
            this.restClient.patch(path, payload);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not save the account settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not save the account settings.", e);
        }
    }

    public void deleteAccountSettings() {
        String path = this.template.urlFor("/account/admin/accountSettings").build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the account settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the account settings.", e);
        }
    }

    public AccountPackageSettings getAccountPackageSettings() {
        String path = this.template.urlFor("/account/admin/accountSettings/packageSettings").build();
        try {
            String stringResponse = this.restClient.get(path);
            return new AccountPackageSettingsConverter(Serialization.fromJson(stringResponse, com.silanis.esl.api.model.AccountPackageSettings.class)).toSDKAccountPackageSettings();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the account package settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the account package settings.", e);
        }
    }

    public void saveAccountPackageSettings(AccountPackageSettings accountPackageSettings) {
        String path = this.template.urlFor("/account/admin/accountSettings/packageSettings").build();
        String payload = JacksonUtil.serialize(accountPackageSettings);
        try {
            this.restClient.patch(path, payload);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not save the account package settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not save the account package settings.", e);
        }
    }

    public void deleteAccountPackageSettings() {
        String path = this.template.urlFor("/account/admin/accountSettings/packageSettings").build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the account package settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the account package settings.", e);
        }
    }

    public AccountFeatureSettings getAccountFeatureSettings() {
        String path = this.template.urlFor("/account/admin/accountSettings/featureSettings").build();
        try {
            String stringResponse = this.restClient.get(path);
            return new AccountFeatureSettingsConverter(Serialization.fromJson(stringResponse, com.silanis.esl.api.model.AccountFeatureSettings.class)).toSDKAccountFeatureSettings();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the account feature settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the account feature settings.", e);
        }
    }

    public void saveAccountFeatureSettings(AccountFeatureSettings accountFeatureSettings) {
        String path = this.template.urlFor("/account/admin/accountSettings/featureSettings").build();
        String payload = JacksonUtil.serialize(accountFeatureSettings);
        try {
            this.restClient.patch(path, payload);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not save the account feature settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not save the account feature settings.", e);
        }
    }

    public void deleteAccountFeatureSettings() {
        String path = this.template.urlFor("/account/admin/accountSettings/featureSettings").build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the account feature settings.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the account feature settings.", e);
        }
    }
}

