/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UnauthenticatedRestClient;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.net.URLEncoder;

public class AuthenticationService {
    private final UnauthenticatedRestClient client;
    private UrlTemplate authenticationUrlTemplate;
    private UrlTemplate redirectUrlTemplate;

    public AuthenticationService(String webpageUrl) {
        this.client = new UnauthenticatedRestClient();
        this.authenticationUrlTemplate = new UrlTemplate(webpageUrl + "/auth");
        this.redirectUrlTemplate = new UrlTemplate(webpageUrl);
    }

    public AuthenticationService(String webpageUrl, ProxyConfiguration proxyConfiguration) {
        this.client = new UnauthenticatedRestClient(proxyConfiguration);
        this.authenticationUrlTemplate = new UrlTemplate(webpageUrl + "/auth");
        this.redirectUrlTemplate = new UrlTemplate(webpageUrl);
    }

    public String getSessionIdForUserAuthenticationToken(String userAuthenticationToken) {
        String path = this.authenticationUrlTemplate.urlFor("?authenticationToken={authenticationToken}").replace("{authenticationToken}", userAuthenticationToken).build();
        try {
            String stringResponse = this.client.get(path);
            SessionToken sessionIdToken = Serialization.fromJson(stringResponse, SessionToken.class);
            return sessionIdToken.getSessionToken();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not authenticate using an authentication token.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not authenticate using an authentication token.", e);
        }
    }

    public String buildRedirectToDesignerForUserAuthenticationToken(String userAuthenticationToken, String packageId) {
        try {
            String redirectPath = this.redirectUrlTemplate.urlFor("/designer/{packageId}").replace("{packageId}", packageId).build();
            String encodedRedirectPath = URLEncoder.encode(redirectPath, "UTF-8");
            String path = this.authenticationUrlTemplate.urlFor("?authenticationToken={authenticationToken}&target={redirectUrl}").replace("{authenticationToken}", userAuthenticationToken).replace("{redirectUrl}", encodedRedirectPath).build();
            return path;
        }
        catch (Exception e) {
            throw new EslException("Could not create a redirect to designer for a sender.", e);
        }
    }

    public String getSessionIdForSenderAuthenticationToken(String senderAuthenticationToken) {
        String path = this.authenticationUrlTemplate.urlFor("?senderAuthenticationToken={senderAuthenticationToken}").replace("{senderAuthenticationToken}", senderAuthenticationToken).build();
        try {
            String stringResponse = this.client.get(path);
            SessionToken sessionIdToken = Serialization.fromJson(stringResponse, SessionToken.class);
            return sessionIdToken.getSessionToken();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not authenticate using a sender authentication token.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not authenticate using a sender authentication token.", e);
        }
    }

    public String buildRedirectToDesignerForSender(String senderAuthenticationToken, String packageId) {
        try {
            String redirectPath = this.redirectUrlTemplate.urlFor("/designer/{packageId}").replace("{packageId}", packageId).build();
            String encodedRedirectPath = URLEncoder.encode(redirectPath, "UTF-8");
            String path = this.authenticationUrlTemplate.urlFor("?senderAuthenticationToken={senderAuthenticationToken}&target={redirectUrl}").replace("{senderAuthenticationToken}", senderAuthenticationToken).replace("{redirectUrl}", encodedRedirectPath).build();
            return path;
        }
        catch (Exception e) {
            throw new EslException("Could not create a redirect to designer for a sender.", e);
        }
    }

    public String buildRedirectToPackageViewForSender(String userAuthenticationToken, String packageId) {
        try {
            String redirectPath = this.redirectUrlTemplate.urlFor("/packages/{packageId}").replace("{packageId}", packageId).build();
            String encodedRedirectPath = URLEncoder.encode(redirectPath, "UTF-8");
            String path = this.authenticationUrlTemplate.urlFor("?authenticationToken={authenticationToken}&target={redirectUrl}").replace("{authenticationToken}", userAuthenticationToken).replace("{redirectUrl}", encodedRedirectPath).build();
            return path;
        }
        catch (Exception e) {
            throw new EslException("Could not create a redirect to package view for a sender.", e);
        }
    }

    public String getSessionIdForSignerAuthenticationToken(String signerAuthenticationToken) {
        String path = this.authenticationUrlTemplate.urlFor("?signerAuthenticationToken={signerAuthenticationToken}").replace("{signerAuthenticationToken}", signerAuthenticationToken).build();
        try {
            String stringResponse = this.client.get(path);
            SessionToken sessionIdToken = Serialization.fromJson(stringResponse, SessionToken.class);
            return sessionIdToken.getSessionToken();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not authenticate using a signer authentication token.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not authenticate using a signer authentication token.", e);
        }
    }

    public String buildRedirectToSigningForSigner(String signerAuthenticationToken, String packageId) {
        try {
            String redirectPath = this.redirectUrlTemplate.urlFor("/transaction/{packageId}/sign").replace("{packageId}", packageId).build();
            String encodedRedirectPath = URLEncoder.encode(redirectPath, "UTF-8");
            String path = this.authenticationUrlTemplate.urlFor("?signerAuthenticationToken={signerAuthenticationToken}&target={redirectUrl}").replace("{signerAuthenticationToken}", signerAuthenticationToken).replace("{redirectUrl}", encodedRedirectPath).build();
            return path;
        }
        catch (Exception e) {
            throw new EslException("Could not create a redirect to signing for a signer", e);
        }
    }
}

