/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.Currency;
import com.silanis.esl.sdk.Price;
import java.util.Map;

public class PriceConverter {
    private Optional<com.silanis.esl.api.model.Price> apiPriceOptional;
    private Optional<Price> sdkPriceOptional;

    public PriceConverter(com.silanis.esl.api.model.Price apiPrice) {
        this.apiPriceOptional = Optional.fromNullable((Object)apiPrice);
        this.sdkPriceOptional = Optional.absent();
    }

    public PriceConverter(Price sdkPrice) {
        this.apiPriceOptional = Optional.absent();
        this.sdkPriceOptional = Optional.fromNullable((Object)sdkPrice);
    }

    public com.silanis.esl.api.model.Price toAPIPrice() {
        if (this.sdkPriceOptional.isPresent()) {
            com.silanis.esl.api.model.Price apiPrice = new com.silanis.esl.api.model.Price();
            Price sdkPrice = (Price)this.sdkPriceOptional.get();
            apiPrice.setAmount(sdkPrice.getAmount());
            if (sdkPrice.getCurrency() != null) {
                com.silanis.esl.api.model.Currency apiCurrency = new com.silanis.esl.api.model.Currency();
                apiCurrency.setId(sdkPrice.getCurrency().getId());
                apiCurrency.setName(sdkPrice.getCurrency().getName());
                apiCurrency.setData((Map)sdkPrice.getCurrency().getData());
                apiPrice.setCurrency(apiCurrency);
            }
            return apiPrice;
        }
        return (com.silanis.esl.api.model.Price)this.apiPriceOptional.orNull();
    }

    public Price toSDKPrice() {
        if (this.apiPriceOptional.isPresent()) {
            Price sdkPrice = new Price();
            com.silanis.esl.api.model.Price apiPrice = (com.silanis.esl.api.model.Price)this.apiPriceOptional.get();
            sdkPrice.setAmount(apiPrice.getAmount());
            if (apiPrice.getCurrency() != null) {
                Currency sdkCurrency = new Currency();
                sdkCurrency.setId(apiPrice.getCurrency().getId());
                sdkCurrency.setName(apiPrice.getCurrency().getName());
                sdkCurrency.setData(apiPrice.getCurrency().getData());
                sdkPrice.setCurrency(sdkCurrency);
            }
            return sdkPrice;
        }
        return (Price)this.sdkPriceOptional.orNull();
    }
}

