/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.CycleCount;
import com.silanis.esl.sdk.Plan;
import com.silanis.esl.sdk.Quota;
import com.silanis.esl.sdk.internal.converter.PriceConverter;
import java.util.Map;

public class PlanConverter {
    private Optional<com.silanis.esl.api.model.Plan> apiPlanOptional;
    private Optional<Plan> sdkPlanOptional;

    public PlanConverter(com.silanis.esl.api.model.Plan apiPlan) {
        this.apiPlanOptional = Optional.fromNullable((Object)apiPlan);
        this.sdkPlanOptional = Optional.absent();
    }

    public PlanConverter(Plan sdkPlan) {
        this.apiPlanOptional = Optional.absent();
        this.sdkPlanOptional = Optional.fromNullable((Object)sdkPlan);
    }

    public com.silanis.esl.api.model.Plan toAPIPlan() {
        if (this.sdkPlanOptional.isPresent()) {
            com.silanis.esl.api.model.Plan apiPlan = new com.silanis.esl.api.model.Plan();
            Plan sdkPlan = (Plan)this.sdkPlanOptional.get();
            apiPlan.setContract(sdkPlan.getContract());
            apiPlan.setCycle(sdkPlan.getCycle());
            apiPlan.setId(sdkPlan.getId());
            apiPlan.setName(sdkPlan.getName());
            apiPlan.setData((Map)sdkPlan.getData());
            apiPlan.setDescription(sdkPlan.getDescription());
            apiPlan.setGroup(sdkPlan.getGroup());
            apiPlan.setOriginal(sdkPlan.getOriginal());
            apiPlan.setFeatures(sdkPlan.getFeatures());
            if (sdkPlan.getPrice() != null) {
                apiPlan.setPrice(new PriceConverter(sdkPlan.getPrice()).toAPIPrice());
            }
            if (sdkPlan.getFreeCycles() != null) {
                com.silanis.esl.api.model.CycleCount apiCycleCount = new com.silanis.esl.api.model.CycleCount();
                apiCycleCount.setCount(sdkPlan.getFreeCycles().getCount());
                apiCycleCount.setCycle(sdkPlan.getFreeCycles().getCycle());
                apiPlan.setFreeCycles(apiCycleCount);
            }
            if (sdkPlan.getQuotas() != null) {
                for (Quota quota : sdkPlan.getQuotas()) {
                    com.silanis.esl.api.model.Quota apiQuota = new com.silanis.esl.api.model.Quota();
                    apiQuota.setCycle(quota.getCycle());
                    apiQuota.setLimit(quota.getLimit());
                    apiQuota.setScope(quota.getScope());
                    apiQuota.setTarget(quota.getTarget());
                    apiPlan.addQuota(apiQuota);
                }
            }
            return apiPlan;
        }
        return (com.silanis.esl.api.model.Plan)this.apiPlanOptional.orNull();
    }

    public Plan toSDKPlan() {
        if (this.apiPlanOptional.isPresent()) {
            Plan sdkPlan = new Plan();
            com.silanis.esl.api.model.Plan apiPlan = (com.silanis.esl.api.model.Plan)this.apiPlanOptional.get();
            sdkPlan.setContract(apiPlan.getContract());
            sdkPlan.setCycle(apiPlan.getCycle());
            sdkPlan.setData(apiPlan.getData());
            sdkPlan.setDescription(apiPlan.getDescription());
            sdkPlan.setFeatures(apiPlan.getFeatures());
            sdkPlan.setId(apiPlan.getId());
            sdkPlan.setName(apiPlan.getName());
            sdkPlan.setGroup(apiPlan.getGroup());
            sdkPlan.setOriginal(apiPlan.getOriginal());
            if (apiPlan.getPrice() != null) {
                sdkPlan.setPrice(new PriceConverter(apiPlan.getPrice()).toSDKPrice());
            }
            if (apiPlan.getFreeCycles() != null) {
                CycleCount sdkCycleCount = new CycleCount();
                sdkCycleCount.setCount(apiPlan.getFreeCycles().getCount());
                sdkCycleCount.setCycle(apiPlan.getFreeCycles().getCycle());
                sdkPlan.setFreeCycles(sdkCycleCount);
            }
            if (apiPlan.getQuotas() != null) {
                for (com.silanis.esl.api.model.Quota quota : apiPlan.getQuotas()) {
                    Quota sdkQuota = new Quota();
                    sdkQuota.setCycle(quota.getCycle());
                    sdkQuota.setLimit(quota.getLimit());
                    sdkQuota.setScope(quota.getScope());
                    sdkQuota.setTarget(quota.getTarget());
                    sdkPlan.addQuota(sdkQuota);
                }
            }
            return sdkPlan;
        }
        return (Plan)this.sdkPlanOptional.orNull();
    }
}

