/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.License;
import com.silanis.esl.sdk.Transaction;
import com.silanis.esl.sdk.internal.converter.PlanConverter;
import com.silanis.esl.sdk.internal.converter.TransactionConverter;

public class LicenseConverter {
    private Optional<com.silanis.esl.api.model.License> apiLicenseOptional;
    private Optional<License> sdkLicenseOptional;

    public LicenseConverter(com.silanis.esl.api.model.License apiLicense) {
        this.apiLicenseOptional = Optional.fromNullable((Object)apiLicense);
        this.sdkLicenseOptional = Optional.absent();
    }

    public LicenseConverter(License sdkLicense) {
        this.apiLicenseOptional = Optional.absent();
        this.sdkLicenseOptional = Optional.fromNullable((Object)sdkLicense);
    }

    public com.silanis.esl.api.model.License toAPILicense() {
        if (this.sdkLicenseOptional.isPresent()) {
            com.silanis.esl.api.model.License apiLicense = new com.silanis.esl.api.model.License();
            License sdkLicense = (License)this.sdkLicenseOptional.get();
            apiLicense.setCreated(sdkLicense.getCreated());
            apiLicense.setPaidUntil(sdkLicense.getPaidUntil());
            apiLicense.setStatus(sdkLicense.getStatus());
            if (sdkLicense.getPlan() != null) {
                apiLicense.setPlan(new PlanConverter(sdkLicense.getPlan()).toAPIPlan());
            }
            if (sdkLicense.getTransactions() != null) {
                for (Transaction transaction : sdkLicense.getTransactions()) {
                    apiLicense.addTransaction(new TransactionConverter(transaction).toAPITransaction());
                }
            }
            return apiLicense;
        }
        return (com.silanis.esl.api.model.License)this.apiLicenseOptional.orNull();
    }

    public License toSDKLicense() {
        if (this.apiLicenseOptional.isPresent()) {
            License sdkLicense = new License();
            com.silanis.esl.api.model.License apiLicense = (com.silanis.esl.api.model.License)this.apiLicenseOptional.get();
            sdkLicense.setCreated(apiLicense.getCreated());
            sdkLicense.setPaidUntil(apiLicense.getPaidUntil());
            sdkLicense.setStatus(apiLicense.getStatus());
            if (apiLicense.getPlan() != null) {
                sdkLicense.setPlan(new PlanConverter(apiLicense.getPlan()).toSDKPlan());
            }
            if (apiLicense.getTransactions() != null) {
                for (com.silanis.esl.api.model.Transaction transaction : apiLicense.getTransactions()) {
                    sdkLicense.addTransaction(new TransactionConverter(transaction).toSDKTransaction());
                }
            }
            return sdkLicense;
        }
        return (License)this.sdkLicenseOptional.orNull();
    }
}

