/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.sdk.ConditionalField;
import com.silanis.esl.sdk.FieldCondition;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.FieldStyle;
import com.silanis.esl.sdk.internal.converter.FieldConditionConverter;
import com.silanis.esl.sdk.internal.converter.FieldStyleAndSubTypeConverter;
import com.silanis.esl.sdk.internal.converter.FieldValidatorConverter;
import com.silanis.esl.sdk.internal.converter.TextAnchorConverter;
import java.util.ArrayList;

public class ConditionalFieldConverter {
    private ConditionalField sdkField = null;
    private com.silanis.esl.api.model.ConditionalField apiField = null;

    public ConditionalFieldConverter(com.silanis.esl.api.model.ConditionalField apiField) {
        this.apiField = apiField;
    }

    public ConditionalFieldConverter(ConditionalField sdkField) {
        this.sdkField = sdkField;
    }

    public com.silanis.esl.api.model.ConditionalField toAPIConditionalField() {
        if (this.sdkField == null) {
            return this.apiField;
        }
        com.silanis.esl.api.model.ConditionalField result = new com.silanis.esl.api.model.ConditionalField();
        result.setPage(this.sdkField.getPage());
        result.setExtract(this.sdkField.isExtraction());
        if (this.sdkField.getName() != null) {
            result.setName(this.sdkField.getName());
        }
        if (!this.sdkField.isExtraction()) {
            result.setLeft(this.sdkField.getX());
            result.setTop(this.sdkField.getY());
            result.setWidth(this.sdkField.getWidth());
            result.setHeight(this.sdkField.getHeight());
        }
        result.setValue(this.sdkField.getValue());
        if (this.sdkField.getStyle() == FieldStyle.BOUND_QRCODE) {
            result.setType("IMAGE");
        } else {
            result.setType("INPUT");
        }
        result.setSubtype(new FieldStyleAndSubTypeConverter(this.sdkField.getStyle()).toAPIFieldSubtype());
        result.setBinding(this.sdkField.getBinding());
        if (this.sdkField.getId() != null) {
            result.setId(this.sdkField.getId().toString());
        }
        if (this.sdkField.getFieldValidator() != null) {
            result.setValidation(new FieldValidatorConverter(this.sdkField.getFieldValidator()).toAPIFieldValidation());
        }
        if (this.sdkField.getTextAnchor() != null) {
            result.setExtractAnchor(new TextAnchorConverter(this.sdkField.getTextAnchor()).toAPIExtractAnchor());
        }
        if (this.sdkField.getConditions() != null) {
            ArrayList<com.silanis.esl.api.model.FieldCondition> conditions = new ArrayList<com.silanis.esl.api.model.FieldCondition>();
            for (FieldCondition condition : this.sdkField.getConditions()) {
                conditions.add(new FieldConditionConverter(condition).toAPIFieldCondition());
            }
            result.setConditions(conditions);
        }
        return result;
    }

    public ConditionalField toSDKConditionalField() {
        if (this.apiField == null) {
            return this.sdkField;
        }
        ConditionalField result = new ConditionalField();
        result.setExtraction(this.apiField.evalExtract());
        if (this.apiField.getValidation() != null) {
            result.setFieldValidator(new FieldValidatorConverter(this.apiField.getValidation()).toSDKFieldValidator());
        }
        result.setId(new FieldId(this.apiField.getId()));
        result.setName(this.apiField.getName());
        if (this.apiField.getPage() != null) {
            result.setPage(this.apiField.getPage());
        }
        result.setStyle(new FieldStyleAndSubTypeConverter(this.apiField.getSubtype(), this.apiField.getBinding()).toSDKFieldStyle());
        result.setTextAnchor(new TextAnchorConverter(this.apiField.getExtractAnchor()).toSDKTextAnchor());
        result.setValue(this.apiField.getValue());
        if (this.apiField.getLeft() != null) {
            result.setX(this.apiField.getLeft());
        }
        if (this.apiField.getTop() != null) {
            result.setY(this.apiField.getTop());
        }
        if (this.apiField.getWidth() != null) {
            result.setWidth(this.apiField.getWidth());
        }
        if (this.apiField.getHeight() != null) {
            result.setHeight(this.apiField.getHeight());
        }
        if (this.apiField.getConditions() != null) {
            ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
            for (com.silanis.esl.api.model.FieldCondition condition : this.apiField.getConditions()) {
                conditions.add(new FieldConditionConverter(condition).toSDKFieldCondition());
            }
            result.setConditions(conditions);
        }
        return result;
    }
}

