/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.AuthenticationMethod;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class AuthenticationMethodConverter {
    private AuthenticationMethod sdkAuthMethod = null;
    private String apiAuthMethod = null;

    public AuthenticationMethodConverter(String apiAuthMethod) {
        this.apiAuthMethod = apiAuthMethod;
    }

    public AuthenticationMethodConverter(AuthenticationMethod sdkAuthMethod) {
        this.sdkAuthMethod = sdkAuthMethod;
    }

    public String toAPIAuthMethod() {
        if (this.sdkAuthMethod == null) {
            return this.apiAuthMethod;
        }
        return this.sdkAuthMethod.getApiValue();
    }

    public AuthenticationMethod toSDKAuthMethod() {
        if (this.apiAuthMethod == null) {
            return this.sdkAuthMethod;
        }
        try {
            return (AuthenticationMethod)Iterables.find(Arrays.asList(AuthenticationMethod.values()), (Predicate)new Predicate<AuthenticationMethod>(){

                public boolean apply(AuthenticationMethod authenticationMethod) {
                    return AuthenticationMethodConverter.this.apiAuthMethod.equals(authenticationMethod.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return AuthenticationMethod.UNRECOGNIZED(this.apiAuthMethod);
        }
    }
}

