/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.SignerVerification;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.builder.SignerVerificationBuilder;
import com.silanis.esl.sdk.examples.SDKSample;

public class SignerVerificationExample
extends SDKSample {
    private static final String CREATE_VERIFICATION_TYPE_ID = "DIGIPASS";
    private static final String CREATE_VERIFICATION_PAYLOAD = "bSxW5aAFG2yTW5NaqaAF";
    private static final String UPDATE_VERIFICATION_TYPE_ID = "personalCertificateSigning";
    private static final String UPDATE_VERIFICATION_PAYLOAD = "";
    public SignerVerification signerVerificationToBeCreated;
    public SignerVerification signerVerificationToBeUpdated;
    public SignerVerification retrievedSignerVerificationAfterCreate;
    public SignerVerification retrievedSignerVerificationAfterUpdate;
    public SignerVerification retrievedSignerVerificationAfterDelete;

    public static void main(String ... args) {
        new SignerVerificationExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John1").withLastName("Smith1")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        Signer signer = this.retrievedPackage.getSigner(this.email1);
        this.signerVerificationToBeCreated = SignerVerificationBuilder.newSignerVerification(CREATE_VERIFICATION_TYPE_ID).withPayload(CREATE_VERIFICATION_PAYLOAD).build();
        this.eslClient.createSignerVerification(this.packageId, signer.getId(), this.signerVerificationToBeCreated);
        this.retrievedSignerVerificationAfterCreate = this.eslClient.getSignerVerification(this.packageId, signer.getId());
        this.signerVerificationToBeUpdated = SignerVerificationBuilder.newSignerVerification(UPDATE_VERIFICATION_TYPE_ID).withPayload(UPDATE_VERIFICATION_PAYLOAD).build();
        this.eslClient.updateSignerVerification(this.packageId, signer.getId(), this.signerVerificationToBeUpdated);
        this.retrievedSignerVerificationAfterUpdate = this.eslClient.getSignerVerification(this.packageId, signer.getId());
        this.eslClient.deleteSignerVerification(this.packageId, signer.getId());
        this.retrievedSignerVerificationAfterDelete = this.eslClient.getSignerVerification(this.packageId, signer.getId());
    }
}

