/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.EslClient;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.ProxyConfigurationBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;

public class ProxyConfigurationExample
extends SDKSample {
    private EslClient eslClientWithHttpProxy;
    private EslClient eslClientWithHttpProxyHasCredentials;
    public DocumentPackage retrievedPackage1;
    public DocumentPackage retrievedPackage2;

    public static void main(String ... args) {
        new ProxyConfigurationExample().run();
    }

    public ProxyConfigurationExample() {
        ProxyConfiguration httpProxyConfiguration = ProxyConfigurationBuilder.newProxyConfiguration().withHttpHost(this.proxyHost).withHttpPort(this.proxyPort).build();
        ProxyConfiguration httpProxyWithCredentialsConfiguration = ProxyConfigurationBuilder.newProxyConfiguration().withHttpHost(this.proxyWithCredentialsHost).withHttpPort(this.proxyWithCredentialsPort).withCredentials(this.proxyUserName, this.proxyPassword).build();
        this.eslClientWithHttpProxy = this.setupEslClientFromProps(Collections.emptyMap(), httpProxyConfiguration);
        this.eslClientWithHttpProxyHasCredentials = this.setupEslClientFromProps(Collections.emptyMap(), httpProxyWithCredentialsConfiguration);
    }

    @Override
    public void execute() {
        HttpProxyServer httpProxyServer = DefaultHttpProxyServer.bootstrap().withPort(this.proxyPort).start();
        DocumentPackage package1 = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("signer1").withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document pdf").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId1 = this.eslClientWithHttpProxy.createAndSendPackage(package1);
        this.eslClientWithHttpProxy.signDocuments(packageId1);
        this.eslClientWithHttpProxy.signDocuments(packageId1, "signer1");
        this.retrievedPackage1 = this.eslClientWithHttpProxy.getPackage(packageId1);
        httpProxyServer.stop();
        HttpProxyServer httpProxyWithCredentialsServer = this.startHttpProxyWithCredentials(this.proxyWithCredentialsPort);
        DocumentPackage package2 = PackageBuilder.newPackageNamed("ProxyConfigurationExample2 " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using the eSignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("signer2").withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document pdf").fromStream(this.documentInputStream2, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId2 = this.eslClientWithHttpProxyHasCredentials.createAndSendPackage(package2);
        this.eslClientWithHttpProxyHasCredentials.signDocuments(packageId2);
        this.eslClientWithHttpProxyHasCredentials.signDocuments(packageId2, "signer2");
        this.retrievedPackage2 = this.eslClientWithHttpProxyHasCredentials.getPackage(packageId2);
        httpProxyWithCredentialsServer.stop();
    }

    private HttpProxyServer startHttpProxyWithCredentials(int port) {
        return DefaultHttpProxyServer.bootstrap().withPort(port).withProxyAuthenticator(new ProxyAuthenticator(){

            public boolean authenticate(String s1, String s2) {
                return "httpUser".equals(s1) && "httpPwd".equals(s2);
            }

            public String getRealm() {
                return null;
            }
        }).start();
    }
}

