/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AccessibleAccountResponse;
import com.silanis.esl.sdk.Account;
import com.silanis.esl.sdk.SubAccount;
import com.silanis.esl.sdk.SubAccountApiKey;
import com.silanis.esl.sdk.builder.SubAccountBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class CreateAndUpdateSubAccountExample
extends SDKSample {
    public List<Account> subAccounts;
    public List<SubAccountApiKey> subAccountApiKeys;
    public List<AccessibleAccountResponse> accessibleAccounts;
    private static final String PARENT_ACCOUNT_ID = "dummyAccountId";
    public static final String NAME = "SubAccount_" + new SimpleDateFormat("HH:mm:ss").format(new Date());
    private static final String TIMEZONE_ID = "GMT";
    private static final String LANGUAGE = "en";
    private static final String UPDATE_TIMEZONE_ID = "Europe/Prague";
    private static final String UPDATE_LANGUAGE = "it";

    public static void main(String ... args) {
        new CreateAndUpdateSubAccountExample().run();
    }

    @Override
    public void execute() {
        SubAccount subAccount = SubAccountBuilder.newSubAccount(NAME).withParentAccountId(PARENT_ACCOUNT_ID).withLanguage(LANGUAGE).withTimezoneId(TIMEZONE_ID).build();
        Account account = this.eslClient.getAccountService().createSubAccount(subAccount);
        SubAccount updateSubAccount = SubAccountBuilder.newSubAccount().withLanguage(UPDATE_LANGUAGE).withTimezoneId(UPDATE_TIMEZONE_ID).build();
        this.eslClient.getAccountService().updateSubAccount(updateSubAccount, account.getId());
        this.accessibleAccounts = this.eslClient.getAccountService().getAccessibleAccounts();
        this.subAccounts = this.eslClient.getAccountService().getSubAccounts();
        this.subAccountApiKeys = this.eslClient.getAccountService().getSubAccountApiKeys();
    }
}

