/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Translation;

public class TranslationBuilder {
    private String name;
    private String language;
    private String description;

    public static TranslationBuilder newTranslation(String language) {
        return new TranslationBuilder(language);
    }

    public static TranslationBuilder newTranslation(com.silanis.esl.api.model.Translation apiTranslation) {
        TranslationBuilder builder = new TranslationBuilder(apiTranslation.getLanguage());
        builder.withName(apiTranslation.getName()).withDescription(apiTranslation.getDescription());
        return builder;
    }

    private TranslationBuilder(String language) {
        this.language = language;
    }

    public TranslationBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public TranslationBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public Translation build() {
        Translation result = new Translation();
        result.setName(this.name);
        result.setDescription(this.description);
        result.setLanguage(this.language);
        return result;
    }
}

