/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Account;
import com.silanis.esl.sdk.AccountProviders;
import com.silanis.esl.sdk.Company;
import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.License;
import com.silanis.esl.sdk.Provider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountBuilder {
    private Company company;
    private Date created;
    private Date updated;
    private List<CustomField> customFields = new ArrayList<CustomField>();
    private List<License> licenses = new ArrayList<License>();
    private String logoUrl = "";
    private String owner = "";
    protected String name;
    private String id;
    private Map<String, Object> data;
    private AccountProviders providers = null;

    private AccountBuilder() {
        this.customFields = new ArrayList<CustomField>();
        this.licenses = new ArrayList<License>();
        this.data = new HashMap<String, Object>();
    }

    public static AccountBuilder newAccount() {
        return new AccountBuilder();
    }

    public AccountBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public AccountBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public AccountBuilder withLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    public AccountBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public AccountBuilder withCompany(Company company) {
        this.company = company;
        return this;
    }

    public AccountBuilder withCreated(Date created) {
        this.created = created;
        return this;
    }

    public AccountBuilder withUpdated(Date updated) {
        this.updated = updated;
        return this;
    }

    public AccountBuilder withCustomField(CustomField customField) {
        this.customFields.add(customField);
        return this;
    }

    public AccountBuilder withLicense(License license) {
        this.licenses.add(license);
        return this;
    }

    public AccountBuilder withAccountProviders(AccountProviders accountProviders) {
        this.providers = accountProviders;
        return this;
    }

    public AccountBuilder withAccountProviders(List<Provider> documents, List<Provider> users) {
        this.providers = new AccountProviders();
        for (Provider provider : documents) {
            this.providers.addDocument(provider);
        }
        for (Provider provider : users) {
            this.providers.addUser(provider);
        }
        return this;
    }

    public AccountBuilder withData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public Account build() {
        Account account = new Account();
        account.setCompany(this.company);
        account.setCreated(this.created);
        account.setUpdated(this.updated);
        for (CustomField field : this.customFields) {
            account.addCustomField(field);
        }
        account.setData(this.data);
        account.setId(this.id);
        for (License license : this.licenses) {
            account.addLicense(license);
        }
        account.setLogoUrl(this.logoUrl);
        account.setName(this.name);
        account.setOwner(this.owner);
        account.setProviders(this.providers);
        return account;
    }
}

