/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.UnknownTransportProtocolException;
import org.littleshoot.proxy.impl.ProxyThreadPools;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerGroup {
    private static final Logger log = LoggerFactory.getLogger(ServerGroup.class);
    public static final int DEFAULT_INCOMING_ACCEPTOR_THREADS = 2;
    public static final int DEFAULT_INCOMING_WORKER_THREADS = 8;
    public static final int DEFAULT_OUTGOING_WORKER_THREADS = 8;
    private static final AtomicInteger serverGroupCount = new AtomicInteger(0);
    private final String name;
    private final int serverGroupId;
    private final int incomingAcceptorThreads;
    private final int incomingWorkerThreads;
    private final int outgoingWorkerThreads;
    public final List<HttpProxyServer> registeredServers = new ArrayList<HttpProxyServer>(1);
    private final EnumMap<TransportProtocol, ProxyThreadPools> protocolThreadPools = new EnumMap(TransportProtocol.class);
    private static final EnumMap<TransportProtocol, SelectorProvider> TRANSPORT_PROTOCOL_SELECTOR_PROVIDERS = new EnumMap(TransportProtocol.class);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final Object THREAD_POOL_INIT_LOCK = new Object();
    private final Object SERVER_REGISTRATION_LOCK = new Object();

    public ServerGroup(String name, int incomingAcceptorThreads, int incomingWorkerThreads, int outgoingWorkerThreads) {
        this.name = name;
        this.serverGroupId = serverGroupCount.getAndIncrement();
        this.incomingAcceptorThreads = incomingAcceptorThreads;
        this.incomingWorkerThreads = incomingWorkerThreads;
        this.outgoingWorkerThreads = outgoingWorkerThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyThreadPools getThreadPoolsForProtocol(TransportProtocol protocol) {
        if (this.protocolThreadPools.get((Object)protocol) == null) {
            Object object = this.THREAD_POOL_INIT_LOCK;
            synchronized (object) {
                if (this.protocolThreadPools.get((Object)protocol) == null) {
                    log.debug("Initializing thread pools for {} with {} acceptor threads, {} incoming worker threads, and {} outgoing worker threads", new Object[]{protocol, this.incomingAcceptorThreads, this.incomingWorkerThreads, this.outgoingWorkerThreads});
                    SelectorProvider selectorProvider = TRANSPORT_PROTOCOL_SELECTOR_PROVIDERS.get((Object)protocol);
                    if (selectorProvider == null) {
                        throw new UnknownTransportProtocolException(protocol);
                    }
                    ProxyThreadPools threadPools = new ProxyThreadPools(selectorProvider, this.incomingAcceptorThreads, this.incomingWorkerThreads, this.outgoingWorkerThreads, this.name, this.serverGroupId);
                    this.protocolThreadPools.put(protocol, threadPools);
                }
            }
        }
        return this.protocolThreadPools.get((Object)protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyServer(HttpProxyServer proxyServer) {
        Object object = this.SERVER_REGISTRATION_LOCK;
        synchronized (object) {
            this.registeredServers.add(proxyServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProxyServer(HttpProxyServer proxyServer, boolean graceful) {
        Object object = this.SERVER_REGISTRATION_LOCK;
        synchronized (object) {
            boolean wasRegistered = this.registeredServers.remove(proxyServer);
            if (!wasRegistered) {
                log.warn("Attempted to unregister proxy server from ServerGroup that it was not registered with. Was the proxy unregistered twice?");
            }
            if (this.registeredServers.isEmpty()) {
                log.debug("Proxy server unregistered from ServerGroup. No proxy servers remain registered, so shutting down ServerGroup.");
                this.shutdown(graceful);
            } else {
                log.debug("Proxy server unregistered from ServerGroup. Not shutting down ServerGroup ({} proxy servers remain registered).", this.registeredServers.size());
            }
        }
    }

    private void shutdown(boolean graceful) {
        if (!this.stopped.compareAndSet(false, true)) {
            log.info("Shutdown requested, but ServerGroup is already stopped. Doing nothing.");
            return;
        }
        log.info("Shutting down server group event loops {}", (Object)(graceful ? "(graceful)" : "(non-graceful)"));
        ArrayList<EventLoopGroup> allEventLoopGroups = new ArrayList<EventLoopGroup>();
        for (ProxyThreadPools threadPools : this.protocolThreadPools.values()) {
            allEventLoopGroups.addAll(threadPools.getAllEventLoops());
        }
        for (EventLoopGroup group : allEventLoopGroups) {
            if (graceful) {
                group.shutdownGracefully();
                continue;
            }
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
        if (graceful) {
            for (EventLoopGroup group : allEventLoopGroups) {
                try {
                    group.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted while shutting down event loop");
                }
            }
        }
        log.debug("Done shutting down server group");
    }

    public EventLoopGroup getClientToProxyAcceptorPoolForTransport(TransportProtocol protocol) {
        return this.getThreadPoolsForProtocol(protocol).getClientToProxyAcceptorPool();
    }

    public EventLoopGroup getClientToProxyWorkerPoolForTransport(TransportProtocol protocol) {
        return this.getThreadPoolsForProtocol(protocol).getClientToProxyWorkerPool();
    }

    public EventLoopGroup getProxyToServerWorkerPoolForTransport(TransportProtocol protocol) {
        return this.getThreadPoolsForProtocol(protocol).getProxyToServerWorkerPool();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    static {
        TRANSPORT_PROTOCOL_SELECTOR_PROVIDERS.put(TransportProtocol.TCP, SelectorProvider.provider());
        if (ProxyUtils.isUdtAvailable()) {
            TRANSPORT_PROTOCOL_SELECTOR_PROVIDERS.put(TransportProtocol.UDT, NioUdtProvider.BYTE_PROVIDER);
        } else {
            log.debug("UDT provider not found on classpath. UDT transport will not be available.");
        }
    }
}

