/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Set<String> SHOULD_NOT_PROXY_HOP_BY_HOP_HEADERS = ImmutableSet.of(HttpHeaderNames.CONNECTION.toString(), HttpHeaderNames.KEEP_ALIVE.toString(), HttpHeaderNames.PROXY_AUTHENTICATE.toString(), HttpHeaderNames.PROXY_AUTHORIZATION.toString(), HttpHeaderNames.TE.toString(), HttpHeaderNames.TRAILER.toString(), new String[]{HttpHeaderNames.UPGRADE.toString()});
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtils.class);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Splitter COMMA_SEPARATED_HEADER_VALUE_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static Pattern HTTP_PREFIX = Pattern.compile("^(http|ws)s?://.*", 2);

    public static String stripHost(String uri) {
        if (!HTTP_PREFIX.matcher(uri).matches()) {
            return uri;
        }
        String noHttpUri = StringUtils.substringAfter(uri, "://");
        int slashIndex = noHttpUri.indexOf("/");
        if (slashIndex == -1) {
            return "/";
        }
        return noHttpUri.substring(slashIndex);
    }

    public static String formatDate(Date date) {
        return ProxyUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
        formatter.setTimeZone(GMT);
        return formatter.format(date);
    }

    public static boolean isLastChunk(HttpObject httpObject) {
        return httpObject instanceof LastHttpContent;
    }

    public static boolean isChunked(HttpObject httpObject) {
        return !ProxyUtils.isLastChunk(httpObject);
    }

    public static String parseHostAndPort(HttpRequest httpRequest) {
        return ProxyUtils.parseHostAndPort(httpRequest.uri());
    }

    public static String parseHostAndPort(String uri) {
        String tempUri = !HTTP_PREFIX.matcher(uri).matches() ? uri : StringUtils.substringAfter(uri, "://");
        String hostAndPort = tempUri.contains("/") ? tempUri.substring(0, tempUri.indexOf("/")) : tempUri;
        return hostAndPort;
    }

    public static HttpResponse copyMutableResponseFields(HttpResponse original) {
        DefaultHttpResponse copy;
        if (original instanceof DefaultFullHttpResponse) {
            ByteBuf content = ((DefaultFullHttpResponse)original).content();
            copy = new DefaultFullHttpResponse(original.protocolVersion(), original.status(), content);
        } else {
            copy = new DefaultHttpResponse(original.protocolVersion(), original.status());
        }
        Set<String> headerNames = original.headers().names();
        for (String name : headerNames) {
            List<String> values = original.headers().getAll(name);
            copy.headers().set(name, (Iterable<?>)values);
        }
        return copy;
    }

    public static void addVia(HttpMessage httpMessage, String alias) {
        List<String> vias;
        String newViaHeader = String.valueOf(httpMessage.protocolVersion().majorVersion()) + '.' + httpMessage.protocolVersion().minorVersion() + ' ' + alias;
        if (httpMessage.headers().contains(HttpHeaderNames.VIA)) {
            List<String> existingViaHeaders = httpMessage.headers().getAll(HttpHeaderNames.VIA);
            vias = new ArrayList<String>(existingViaHeaders);
            vias.add(newViaHeader);
        } else {
            vias = Collections.singletonList(newViaHeader);
        }
        httpMessage.headers().set((CharSequence)HttpHeaderNames.VIA, vias);
    }

    public static boolean isTrue(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "true", "on");
    }

    public static boolean isFalse(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "false", "off");
    }

    public static boolean extractBooleanDefaultFalse(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank(throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return false;
    }

    public static boolean extractBooleanDefaultTrue(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank(throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return true;
    }

    public static int extractInt(Properties props, String key) {
        return ProxyUtils.extractInt(props, key, -1);
    }

    public static int extractInt(Properties props, String key, int defaultValue) {
        String readThrottleString = props.getProperty(key);
        if (StringUtils.isNotBlank(readThrottleString) && NumberUtils.isCreatable(readThrottleString)) {
            return Integer.parseInt(readThrottleString);
        }
        return defaultValue;
    }

    public static boolean isCONNECT(HttpObject httpObject) {
        return httpObject instanceof HttpRequest && HttpMethod.CONNECT.equals(((HttpRequest)httpObject).method());
    }

    public static boolean isHEAD(HttpRequest httpRequest) {
        return httpRequest != null && HttpMethod.HEAD.equals(httpRequest.method());
    }

    private static boolean checkTrueOrFalse(String val, String str1, String str2) {
        String str = val.trim();
        return StringUtils.isNotBlank(str) && (str.equalsIgnoreCase(str1) || str.equalsIgnoreCase(str2));
    }

    public static boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code = res.status().code();
            if (code >= 100 && code < 200) {
                return true;
            }
            switch (code) {
                case 204: 
                case 205: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isResponseSelfTerminating(HttpResponse response) {
        if (ProxyUtils.isContentAlwaysEmpty(response)) {
            return true;
        }
        List<String> allTransferEncodingHeaders = ProxyUtils.getAllCommaSeparatedHeaderValues(HttpHeaderNames.TRANSFER_ENCODING, response);
        if (!allTransferEncodingHeaders.isEmpty()) {
            String finalEncoding = allTransferEncodingHeaders.get(allTransferEncodingHeaders.size() - 1);
            return HttpHeaderValues.CHUNKED.toString().equals(finalEncoding);
        }
        String contentLengthHeader = response.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        return contentLengthHeader != null && !contentLengthHeader.isEmpty();
    }

    public static List<String> getAllCommaSeparatedHeaderValues(AsciiString headerName, HttpMessage httpMessage) {
        List<String> allHeaders = httpMessage.headers().getAll(headerName);
        if (allHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder headerValues = ImmutableList.builder();
        for (String header : allHeaders) {
            List<String> commaSeparatedValues = ProxyUtils.splitCommaSeparatedHeaderValues(header);
            headerValues.addAll(commaSeparatedValues);
        }
        return headerValues.build();
    }

    public static HttpResponse duplicateHttpResponse(HttpResponse originalResponse) {
        DefaultHttpResponse newResponse = new DefaultHttpResponse(originalResponse.protocolVersion(), originalResponse.status());
        newResponse.headers().add(originalResponse.headers());
        return newResponse;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (IOException | RuntimeException e) {
            LOG.debug("Ignored exception", e);
            LOG.info("Could not lookup localhost");
            return null;
        }
    }

    public static boolean shouldRemoveHopByHopHeader(String headerName) {
        return SHOULD_NOT_PROXY_HOP_BY_HOP_HEADERS.contains(headerName);
    }

    public static List<String> splitCommaSeparatedHeaderValues(String headerValue) {
        return ImmutableList.copyOf(COMMA_SEPARATED_HEADER_VALUE_SPLITTER.split(headerValue));
    }

    public static boolean isUdtAvailable() {
        try {
            return NioUdtProvider.BYTE_PROVIDER != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (VerifyError e) {
            return false;
        }
    }

    public static FullHttpResponse createFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus status, String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        ByteBuf content = Unpooled.copiedBuffer(bytes);
        return ProxyUtils.createFullHttpResponse(httpVersion, status, "text/html; charset=utf-8", content, bytes.length);
    }

    public static FullHttpResponse createFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus status) {
        return ProxyUtils.createFullHttpResponse(httpVersion, status, null, null, 0);
    }

    public static FullHttpResponse createFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus status, String contentType, ByteBuf body, int contentLength) {
        DefaultFullHttpResponse response;
        if (body != null) {
            response = new DefaultFullHttpResponse(httpVersion, status, body);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLength);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        } else {
            response = new DefaultFullHttpResponse(httpVersion, status);
        }
        return response;
    }

    public static void removeSdchEncoding(HttpHeaders headers) {
        List<String> encodings = headers.getAll(HttpHeaderNames.ACCEPT_ENCODING);
        headers.remove(HttpHeaderNames.ACCEPT_ENCODING);
        for (String encoding : encodings) {
            if (encoding == null || !StringUtils.isNotBlank(encoding = encoding.replaceAll(",? *(sdch|SDCH)", "").replaceFirst("^ *, *", ""))) continue;
            headers.add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)encoding);
        }
    }

    public static boolean isSwitchingToWebSocketProtocol(HttpResponse response) {
        return response.status() == HttpResponseStatus.SWITCHING_PROTOCOLS && response.headers().contains(HttpHeaderNames.CONNECTION, HttpHeaderNames.UPGRADE, true) && response.headers().contains(HttpHeaderNames.UPGRADE, (CharSequence)"websocket", true);
    }
}

