/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.xml.DOMConfigurator;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.extras.SelfSignedMitmManager;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final Logger LOG = LoggerFactory.getLogger(Launcher.class);
    private static final String OPTION_DNSSEC = "dnssec";
    private static final String OPTION_PORT = "port";
    private static final String OPTION_HELP = "help";
    private static final String OPTION_MITM = "mitm";
    private static final String OPTION_NIC = "nic";

    public static void main(String ... args) {
        String val;
        int port;
        CommandLine cmd;
        Launcher.pollLog4JConfigurationFileIfAvailable();
        LOG.info("Running LittleProxy with args: {}", Arrays.asList(args));
        Options options = new Options();
        options.addOption(null, OPTION_DNSSEC, true, "Request and verify DNSSEC signatures.");
        options.addOption(null, OPTION_PORT, true, "Run on the specified port.");
        options.addOption(null, OPTION_NIC, true, "Run on a specified Nic");
        options.addOption(null, OPTION_HELP, false, "Display command line help.");
        options.addOption(null, OPTION_MITM, false, "Run as man in the middle.");
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
            if (cmd.getArgs().length > 0) {
                throw new UnrecognizedOptionException("Extra arguments were provided in " + Arrays.asList(args));
            }
        }
        catch (ParseException e) {
            Launcher.printHelp(options, "Could not parse command line: " + Arrays.asList(args));
            return;
        }
        if (cmd.hasOption(OPTION_HELP)) {
            Launcher.printHelp(options, null);
            return;
        }
        int defaultPort = 8080;
        if (cmd.hasOption(OPTION_PORT)) {
            String val2 = cmd.getOptionValue(OPTION_PORT);
            try {
                port = Integer.parseInt(val2);
            }
            catch (NumberFormatException e) {
                Launcher.printHelp(options, "Unexpected port " + val2);
                return;
            }
        } else {
            port = 8080;
        }
        System.out.println("About to start server on port: " + port);
        HttpProxyServerBootstrap bootstrap = DefaultHttpProxyServer.bootstrapFromFile("./littleproxy.properties").withPort(port).withAllowLocalOnly(false);
        if (cmd.hasOption(OPTION_NIC)) {
            val = cmd.getOptionValue(OPTION_NIC);
            bootstrap.withNetworkInterface(new InetSocketAddress(val, 0));
        }
        if (cmd.hasOption(OPTION_MITM)) {
            LOG.info("Running as Man in the Middle");
            bootstrap.withManInTheMiddle(new SelfSignedMitmManager());
        }
        if (cmd.hasOption(OPTION_DNSSEC)) {
            val = cmd.getOptionValue(OPTION_DNSSEC);
            if (ProxyUtils.isTrue(val)) {
                LOG.info("Using DNSSEC");
                bootstrap.withUseDnsSec(true);
            } else if (ProxyUtils.isFalse(val)) {
                LOG.info("Not using DNSSEC");
                bootstrap.withUseDnsSec(false);
            } else {
                Launcher.printHelp(options, "Unexpected value for dnssec=:" + val);
                return;
            }
        }
        System.out.println("About to start...");
        bootstrap.start();
    }

    private static void printHelp(Options options, String errorMessage) {
        if (!StringUtils.isBlank(errorMessage)) {
            LOG.error(errorMessage);
            System.err.println(errorMessage);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("littleproxy", options);
    }

    private static void pollLog4JConfigurationFileIfAvailable() {
        File log4jConfigurationFile = new File("src/test/resources/log4j.xml");
        if (log4jConfigurationFile.exists()) {
            DOMConfigurator.configureAndWatch((String)log4jConfigurationFile.getAbsolutePath(), (long)15L);
        }
    }
}

