/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.VirtualRoom;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.VirtualRoomConverter;

public class VirtualRoomService {
    private final UrlTemplate template;
    private final RestClient client;

    public VirtualRoomService(RestClient client, String baseUrl) {
        this.client = client;
        this.template = new UrlTemplate(baseUrl);
    }

    public VirtualRoom getVirtualRoom(PackageId packageId) {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/virtual-room/config").replace("{packageId}", packageId.getId()).build();
        try {
            stringResponse = this.client.get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get virtual room configuration.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get virtual room configuration.", e);
        }
        com.silanis.esl.api.model.VirtualRoom virtualRoom = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.VirtualRoom.class);
        VirtualRoomConverter converter = new VirtualRoomConverter(virtualRoom);
        return converter.toSDKVirtualRoom();
    }

    public void setVirtualRoom(PackageId packageId, VirtualRoom virtualRoom) {
        String path = this.template.urlFor("/packages/{packageId}/virtual-room/config").replace("{packageId}", packageId.getId()).build();
        VirtualRoomConverter converter = new VirtualRoomConverter(virtualRoom);
        String virtualRoomJson = Serialization.toJson(converter.toAPIVirtualRoom());
        try {
            this.client.put(path, virtualRoomJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update virtualRoom", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update virtualRoom", e);
        }
    }
}

