/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.silanis.esl.api.model.PackageReminderSchedule;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.ReminderSchedule;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.ReminderScheduleConverter;

public class ReminderService {
    private final UrlTemplate template;
    private final RestClient client;

    public ReminderService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public ReminderSchedule getReminderScheduleForPackage(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}/reminders").replace("{packageId}", packageId.getId()).build();
        try {
            String stringResponse = this.client.get(path);
            if (stringResponse != null) {
                PackageReminderSchedule apiReminderSchedule = JacksonUtil.deserialize(stringResponse, new TypeReference<PackageReminderSchedule>(){});
                ReminderSchedule sdkReminder = new ReminderScheduleConverter(apiReminderSchedule).toSDKReminderSchedule();
                return sdkReminder;
            }
            return null;
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to retrieve reminder.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve reminder.", e);
        }
    }

    @Deprecated
    public ReminderSchedule setReminderScheduleForPackage(ReminderSchedule reminderSchedule) {
        return this.createReminderScheduleForPackage(reminderSchedule);
    }

    public ReminderSchedule createReminderScheduleForPackage(ReminderSchedule reminderSchedule) {
        String path = this.template.urlFor("/packages/{packageId}/reminders").replace("{packageId}", reminderSchedule.getPackageId().getId()).build();
        PackageReminderSchedule apiReminderSchedule = new ReminderScheduleConverter(reminderSchedule).toAPIPackageReminderSchedule();
        try {
            String stringResponse = this.client.post(path, Serialization.toJson(apiReminderSchedule));
            PackageReminderSchedule apiResponse = Serialization.fromJson(stringResponse, PackageReminderSchedule.class);
            return new ReminderScheduleConverter(apiResponse).toSDKReminderSchedule();
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to create a new reminder.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to create a new reminder.", e);
        }
    }

    public ReminderSchedule updateReminderScheduleForPackage(ReminderSchedule reminderSchedule) {
        String path = this.template.urlFor("/packages/{packageId}/reminders").replace("{packageId}", reminderSchedule.getPackageId().getId()).build();
        PackageReminderSchedule apiReminderSchedule = new ReminderScheduleConverter(reminderSchedule).toAPIPackageReminderSchedule();
        try {
            String stringResponse = this.client.put(path, Serialization.toJson(apiReminderSchedule));
            PackageReminderSchedule apiResponse = Serialization.fromJson(stringResponse, PackageReminderSchedule.class);
            return new ReminderScheduleConverter(apiResponse).toSDKReminderSchedule();
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to update the reminder.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to update the reminder.", e);
        }
    }

    public void clearReminderScheduleForPackage(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}/reminders").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to clear reminder schedule for package with ID: " + packageId.getId(), e);
        }
        catch (Exception e) {
            throw new EslException("Unable to clear reminder schedule for package with ID: " + packageId.getId(), e);
        }
    }
}

