/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.Visibility;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class VisibilityConverter {
    private Visibility sdkVisibility = null;
    private String apiVisibility = null;

    public VisibilityConverter(String apiVisibility) {
        this.apiVisibility = apiVisibility;
    }

    public VisibilityConverter(Visibility sdkVisibility) {
        this.sdkVisibility = sdkVisibility;
    }

    public Visibility toSDKVisibility() {
        if (this.apiVisibility == null) {
            return this.sdkVisibility;
        }
        try {
            return Iterables.find(Arrays.asList(Visibility.values()), new Predicate<Visibility>(){

                @Override
                public boolean apply(Visibility visibility) {
                    return VisibilityConverter.this.apiVisibility.equals(visibility.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return Visibility.UNRECOGNIZED(this.apiVisibility);
        }
    }

    public String toAPIVisibility() {
        if (this.sdkVisibility == null) {
            return this.apiVisibility;
        }
        return this.sdkVisibility.getApiValue();
    }
}

