/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.sdk.SenderUsageReport;
import com.silanis.esl.sdk.UsageReport;
import com.silanis.esl.sdk.UsageReportCategory;
import com.silanis.esl.sdk.internal.converter.SenderConverter;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class UsageReportConverter {
    private UsageReport sdkUsageReport = null;
    private com.silanis.esl.api.model.UsageReport apiUsageReport = null;

    public UsageReportConverter(com.silanis.esl.api.model.UsageReport apiUsageReport) {
        this.apiUsageReport = apiUsageReport;
    }

    public UsageReport toSDKUsageReport() {
        if (this.apiUsageReport == null) {
            return this.sdkUsageReport;
        }
        List<com.silanis.esl.api.model.SenderUsageReport> senderUsageReportList = this.apiUsageReport.getSenders();
        if (senderUsageReportList.size() != 0) {
            UsageReport result = new UsageReport();
            result.setFrom(this.apiUsageReport.getFrom());
            result.setTo(this.apiUsageReport.getTo());
            result.setSenderUsageReports(Lists.newArrayList(Iterables.transform(senderUsageReportList, new Function<com.silanis.esl.api.model.SenderUsageReport, SenderUsageReport>(){

                @Override
                public SenderUsageReport apply(com.silanis.esl.api.model.SenderUsageReport input) {
                    return UsageReportConverter.this.toSDKSenderUsageReport(input);
                }
            })));
            return result;
        }
        return this.sdkUsageReport;
    }

    private SenderUsageReport toSDKSenderUsageReport(com.silanis.esl.api.model.SenderUsageReport apiSenderUsageReport) {
        SenderUsageReport sdkSenderUsageReport = new SenderUsageReport();
        sdkSenderUsageReport.setSender(new SenderConverter(apiSenderUsageReport.getSender()).toSDKSender());
        EnumMap<UsageReportCategory, Integer> categoryCount = new EnumMap<UsageReportCategory, Integer>(UsageReportCategory.class);
        for (Map.Entry<String, Object> entry : apiSenderUsageReport.getPackages().entrySet()) {
            UsageReportCategory usageReportCategory = UsageReportCategory.valueOf(entry.getKey().toUpperCase());
            categoryCount.put(usageReportCategory, (Integer)entry.getValue());
        }
        sdkSenderUsageReport.setCountByUsageReportCategory(categoryCount);
        return sdkSenderUsageReport;
    }
}

