/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.SenderType;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class SenderTypeConverter {
    private SenderType sdkSenderType = null;
    private String apiSenderType = null;

    public SenderTypeConverter(String apiSenderType) {
        this.apiSenderType = apiSenderType;
    }

    public SenderTypeConverter(SenderType sdkSenderType) {
        this.sdkSenderType = sdkSenderType;
    }

    public SenderType toSDKSenderType() {
        if (this.apiSenderType == null) {
            return this.sdkSenderType;
        }
        try {
            return Iterables.find(Arrays.asList(SenderType.values()), new Predicate<SenderType>(){

                @Override
                public boolean apply(SenderType senderType) {
                    return SenderTypeConverter.this.apiSenderType.equals(senderType.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return SenderType.UNRECOGNIZED(this.apiSenderType);
        }
    }

    public String toAPISenderType() {
        if (this.sdkSenderType == null) {
            return this.apiSenderType;
        }
        return this.sdkSenderType.getApiValue();
    }
}

