/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.SenderStatus;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class SenderStatusConverter {
    private SenderStatus sdkSenderStatus = null;
    private String apiSenderStatus = null;

    public SenderStatusConverter(String apiSenderStatus) {
        this.apiSenderStatus = apiSenderStatus;
    }

    public SenderStatusConverter(SenderStatus sdkSenderStatus) {
        this.sdkSenderStatus = sdkSenderStatus;
    }

    public SenderStatus toSDKSenderStatus() {
        if (this.apiSenderStatus == null) {
            return this.sdkSenderStatus;
        }
        try {
            return Iterables.find(Arrays.asList(SenderStatus.values()), new Predicate<SenderStatus>(){

                @Override
                public boolean apply(SenderStatus senderStatus) {
                    return SenderStatusConverter.this.apiSenderStatus.equals(senderStatus.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return SenderStatus.UNRECOGNIZED(this.apiSenderStatus);
        }
    }

    public String toAPISenderStatus() {
        if (this.sdkSenderStatus == null) {
            return this.apiSenderStatus;
        }
        return this.sdkSenderStatus.getApiValue();
    }
}

