/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.PackageReminder;
import com.silanis.esl.api.model.PackageReminderSchedule;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Reminder;
import com.silanis.esl.sdk.ReminderSchedule;
import com.silanis.esl.sdk.internal.converter.ReminderConverter;

public class ReminderScheduleConverter {
    private final PackageReminderSchedule api;
    private final ReminderSchedule sdk;

    public ReminderScheduleConverter(PackageReminderSchedule api) {
        this.api = api;
        this.sdk = null;
    }

    public ReminderScheduleConverter(ReminderSchedule sdk) {
        this.sdk = sdk;
        this.api = null;
    }

    public PackageReminderSchedule toAPIPackageReminderSchedule() {
        if (this.api != null) {
            return this.api;
        }
        PackageReminderSchedule result = new PackageReminderSchedule();
        if (this.sdk.getPackageId() != null) {
            result.setPackageId(this.sdk.getPackageId().getId());
        }
        result.setStartInDaysDelay(this.sdk.getDaysUntilFirstReminder());
        result.setIntervalInDays(this.sdk.getDaysBetweenReminders());
        result.setRepetitionsCount(this.sdk.getNumberOfRepetitions());
        for (Reminder sdkReminder : this.sdk.getReminders()) {
            result.getReminders().add(new ReminderConverter(sdkReminder).toAPIPackageReminder());
        }
        return result;
    }

    public ReminderSchedule toSDKReminderSchedule() {
        if (this.sdk != null) {
            return this.sdk;
        }
        ReminderSchedule result = new ReminderSchedule();
        if (this.api.getPackageId() != null && !this.api.getPackageId().equals("")) {
            result.setPackageId(new PackageId(this.api.getPackageId()));
        }
        if (this.api.getIntervalInDays() != null) {
            result.setDaysBetweenReminders(this.api.getIntervalInDays());
        }
        if (this.api.getStartInDaysDelay() != null) {
            result.setDaysUntilFirstReminder(this.api.getStartInDaysDelay());
        }
        if (this.api.getRepetitionsCount() != null) {
            result.setNumberOfRepetitions(this.api.getRepetitionsCount());
        }
        for (PackageReminder apiReminder : this.api.getReminders()) {
            result.getReminders().add(new ReminderConverter(apiReminder).toSDKReminder());
        }
        return result;
    }
}

