/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.Provider;
import java.util.Map;

public class ProviderConverter {
    private Optional<com.silanis.esl.api.model.Provider> apiProviderOptional;
    private Optional<Provider> sdkProviderOptional;

    public ProviderConverter(com.silanis.esl.api.model.Provider apiProvider) {
        this.apiProviderOptional = Optional.fromNullable(apiProvider);
        this.sdkProviderOptional = Optional.absent();
    }

    public ProviderConverter(Provider sdkProvider) {
        this.apiProviderOptional = Optional.absent();
        this.sdkProviderOptional = Optional.fromNullable(sdkProvider);
    }

    public com.silanis.esl.api.model.Provider toAPIProvider() {
        if (this.sdkProviderOptional.isPresent()) {
            com.silanis.esl.api.model.Provider apiProvider = new com.silanis.esl.api.model.Provider();
            Provider sdkProvider = this.sdkProviderOptional.get();
            apiProvider.setProvides(sdkProvider.getProvides());
            apiProvider.setId(sdkProvider.getId());
            apiProvider.setName(sdkProvider.getName());
            apiProvider.setData((Map)sdkProvider.getData());
            return apiProvider;
        }
        return this.apiProviderOptional.orNull();
    }

    public Provider toSDKProvider() {
        if (this.apiProviderOptional.isPresent()) {
            Provider sdkProvider = new Provider();
            com.silanis.esl.api.model.Provider apiProvider = this.apiProviderOptional.get();
            sdkProvider.setProvides(apiProvider.getProvides());
            sdkProvider.setId(apiProvider.getId());
            sdkProvider.setName(apiProvider.getName());
            sdkProvider.setData(apiProvider.getData());
            return sdkProvider;
        }
        return this.sdkProviderOptional.orNull();
    }
}

