/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.sdk.Group;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.GroupMember;
import com.silanis.esl.sdk.builder.GroupBuilder;
import com.silanis.esl.sdk.internal.converter.GroupMemberConverter;

public class GroupConverter {
    private Group sdkGroup = null;
    private com.silanis.esl.api.model.Group apiGroup = null;

    public GroupConverter(com.silanis.esl.api.model.Group apiGroup) {
        this.apiGroup = apiGroup;
    }

    public GroupConverter(Group sdkGroup) {
        this.sdkGroup = sdkGroup;
    }

    public com.silanis.esl.api.model.Group toAPIGroup() {
        if (this.sdkGroup == null) {
            return this.apiGroup;
        }
        com.silanis.esl.api.model.Group result = this.toAPIGroupWithoutMembers();
        result.setMembers(Lists.newArrayList(Iterables.transform(this.sdkGroup.getMembers(), new Function<GroupMember, com.silanis.esl.api.model.GroupMember>(){

            @Override
            public com.silanis.esl.api.model.GroupMember apply(GroupMember input) {
                return new GroupMemberConverter(input).toAPIGroupMember();
            }
        })));
        return result;
    }

    public com.silanis.esl.api.model.Group toAPIGroupWithoutMembers() {
        if (this.sdkGroup == null) {
            return this.apiGroup;
        }
        com.silanis.esl.api.model.Group result = new com.silanis.esl.api.model.Group();
        result.setName(this.sdkGroup.getName());
        result.safeSetCreated(this.sdkGroup.getCreated());
        result.safeSetUpdated(this.sdkGroup.getUpdated());
        result.safeSetEmail(this.sdkGroup.getEmail());
        result.safeSetEmailMembers(this.sdkGroup.getEmailMembers());
        if (this.sdkGroup.getId() != null) {
            result.safeSetId(this.sdkGroup.getId().getId());
        }
        return result;
    }

    public Group toSDKGroup() {
        if (this.apiGroup == null) {
            return this.sdkGroup;
        }
        GroupBuilder builder = GroupBuilder.newGroup(this.apiGroup.getName()).withEmail(this.apiGroup.getEmail());
        builder = this.apiGroup.getEmailMembers() != false ? builder.withIndividualMemberEmailing() : builder.withoutIndividualMemberEmailing();
        if (this.apiGroup.getId() != null) {
            builder.withId(new GroupId(this.apiGroup.getId()));
        }
        Group result = builder.build();
        result.getMembers().addAll(Lists.newArrayList(Iterables.transform(this.apiGroup.getMembers(), new Function<com.silanis.esl.api.model.GroupMember, GroupMember>(){

            @Override
            public GroupMember apply(com.silanis.esl.api.model.GroupMember input) {
                return new GroupMemberConverter(input).toSDKGroupMember();
            }
        })));
        return result;
    }
}

