/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.NotificationEvent;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class EventNotificationConverter {
    private NotificationEvent sdkNotificationEvent = null;
    private String apiCallbackEvent = null;

    public EventNotificationConverter(NotificationEvent sdkNotificationEvent) {
        this.sdkNotificationEvent = sdkNotificationEvent;
    }

    public EventNotificationConverter(String apiCallbackEvent) {
        this.apiCallbackEvent = apiCallbackEvent;
    }

    public String toAPICallbackEvent() {
        if (this.sdkNotificationEvent == null) {
            return this.apiCallbackEvent;
        }
        return this.sdkNotificationEvent.getApiValue();
    }

    public NotificationEvent toSDKNotificationEvent() {
        if (this.apiCallbackEvent == null) {
            return this.sdkNotificationEvent;
        }
        try {
            return Iterables.find(Arrays.asList(NotificationEvent.values()), new Predicate<NotificationEvent>(){

                @Override
                public boolean apply(NotificationEvent notificationEvent) {
                    return EventNotificationConverter.this.apiCallbackEvent.equals(notificationEvent.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return NotificationEvent.UNRECOGNIZED(this.apiCallbackEvent);
        }
    }
}

