/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.api.model.BaseMessage;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.FieldCondition;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Message;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.DocumentPackageAttributesBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.internal.converter.AttachmentRequirementConverter;
import com.silanis.esl.sdk.internal.converter.DocumentConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageSettingsConverter;
import com.silanis.esl.sdk.internal.converter.FieldConditionConverter;
import com.silanis.esl.sdk.internal.converter.LocaleConverter;
import com.silanis.esl.sdk.internal.converter.MessageConverter;
import com.silanis.esl.sdk.internal.converter.PackageStatusConverter;
import com.silanis.esl.sdk.internal.converter.SenderConverter;
import com.silanis.esl.sdk.internal.converter.SignerConverter;
import com.silanis.esl.sdk.internal.converter.VisibilityConverter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class DocumentPackageConverter {
    private Package apiPackage;
    private DocumentPackage sdkPackage;

    public DocumentPackageConverter(Package apiPackage) {
        this.apiPackage = apiPackage;
    }

    public DocumentPackageConverter(DocumentPackage sdkPackage) {
        this.sdkPackage = sdkPackage;
    }

    public Package toAPIPackage() {
        if (this.sdkPackage == null) {
            return this.apiPackage;
        }
        Package result = new Package().safeSetName(this.sdkPackage.getName()).safeSetDue(this.sdkPackage.getExpiryDate()).safeSetAutocomplete(this.sdkPackage.getAutocomplete()).safeSetNotarized(this.sdkPackage.getNotarized()).safeSetTrashed(this.sdkPackage.getTrashed());
        if (this.sdkPackage.getId() != null) {
            result.setId(this.sdkPackage.getId().toString());
        }
        if (this.sdkPackage.getDescription() != null && !this.sdkPackage.getDescription().isEmpty()) {
            result.setDescription(this.sdkPackage.getDescription());
        }
        if (this.sdkPackage.getPackageMessage() != null && !this.sdkPackage.getPackageMessage().isEmpty()) {
            result.setEmailMessage(this.sdkPackage.getPackageMessage());
        }
        if (this.sdkPackage.getAttributes() != null) {
            result.setData((Map)this.sdkPackage.getAttributes().toMap());
        }
        if (this.sdkPackage.getLanguage() != null) {
            result.setLanguage(LocaleConverter.convertToString(this.sdkPackage.getLanguage()));
        }
        if (this.sdkPackage.getSettings() != null) {
            result.setSettings(new DocumentPackageSettingsConverter(this.sdkPackage.getSettings()).toAPIPackageSettings());
        }
        if (this.sdkPackage.getSenderInfo() != null) {
            result.setSender(new SenderConverter(this.sdkPackage.getSenderInfo()).toAPISender());
        }
        if (this.sdkPackage.getVisibility() != null) {
            result.setVisibility(new VisibilityConverter(this.sdkPackage.getVisibility()).toAPIVisibility());
        }
        if (this.sdkPackage.getStatus() != null) {
            result.setStatus(new PackageStatusConverter(this.sdkPackage.getStatus()).toAPIPackageStatus());
        }
        result.safeSetTimezoneId(this.sdkPackage.getTimezoneId());
        ArrayList<Role> roles = Lists.newArrayList(Iterables.transform(this.sdkPackage.getSigners(), new Function<Signer, Role>(){
            int signerCount = 1;

            @Override
            public Role apply(Signer input) {
                String id = input.getId() != null ? input.getId() : (input.getGroupId() == null ? "role" + this.signerCount : input.getGroupId().getId());
                Role role = new Role().setName(input.getId() == null ? "signer" + this.signerCount : input.getId()).addSigner(new SignerConverter(input).toAPISigner()).setIndex(input.getSigningOrder()).setReassign(input.canChangeSigner()).setLocked(input.isLocked()).setId(id);
                ++this.signerCount;
                if (input.getMessage() != null) {
                    role.setEmailMessage(new BaseMessage().setContent(input.getMessage()));
                }
                for (AttachmentRequirement attachmentRequirement : input.getAttachmentRequirements()) {
                    role.addAttachmentRequirement(new AttachmentRequirementConverter(attachmentRequirement).toAPIAttachmentRequirement());
                }
                String localLanguage = input.getLocalLanguage();
                if (localLanguage != null) {
                    role.putData("localLanguage", localLanguage);
                }
                return role;
            }
        }));
        result.safeSetRoles(roles);
        for (Signer signer : this.sdkPackage.getPlaceholders()) {
            Role role = new SignerConverter(signer).toAPIRole(signer.getId(), signer.getPlaceholderName());
            role.setIndex(signer.getSigningOrder());
            result.addRole(role);
        }
        if (this.sdkPackage.getConditions() != null) {
            ArrayList<com.silanis.esl.api.model.FieldCondition> conditions = new ArrayList<com.silanis.esl.api.model.FieldCondition>();
            for (FieldCondition condition : this.sdkPackage.getConditions()) {
                conditions.add(new FieldConditionConverter(condition).toAPIFieldCondition());
            }
            result.setConditions(conditions);
        }
        return result;
    }

    public DocumentPackage toSDKPackage() {
        if (this.apiPackage == null) {
            return this.sdkPackage;
        }
        PackageBuilder packageBuilder = PackageBuilder.newPackageNamed(this.apiPackage.getName());
        packageBuilder.withID(new PackageId(this.apiPackage.getId()));
        packageBuilder.autocomplete(this.apiPackage.evalAutocomplete());
        packageBuilder.expiresAt(this.apiPackage.getDue());
        packageBuilder.withStatus(new PackageStatusConverter(this.apiPackage.getStatus()).toSDKPackageStatus());
        if (this.apiPackage.getDescription() != null) {
            packageBuilder.describedAs(this.apiPackage.getDescription());
        }
        if (this.apiPackage.getEmailMessage() != null) {
            packageBuilder.withEmailMessage(this.apiPackage.getEmailMessage());
        }
        if (this.apiPackage.getNotarized() != null) {
            packageBuilder.withNotarized(this.apiPackage.getNotarized());
        }
        if (this.apiPackage.getTrashed() != null) {
            packageBuilder.withTrashed(this.apiPackage.getTrashed());
        }
        if (this.apiPackage.getLanguage() != null) {
            packageBuilder.withLanguage(this.toSdkLanguage(this.apiPackage.getLanguage()));
        }
        if (this.apiPackage.getSettings() != null) {
            packageBuilder.withSettings(new DocumentPackageSettingsConverter(this.apiPackage.getSettings()).toSDKPackageSettings());
        }
        if (this.apiPackage.getSender() != null) {
            packageBuilder.withSenderInfo(new SenderConverter(this.apiPackage.getSender()).toSDKSenderInfo());
        }
        if (this.apiPackage.getVisibility() != null) {
            packageBuilder.withVisibility(new VisibilityConverter(this.apiPackage.getVisibility()).toSDKVisibility());
        }
        if (this.apiPackage.getTimezoneId() != null) {
            packageBuilder.withTimezoneId(this.apiPackage.getTimezoneId());
        }
        packageBuilder.withAttributes(new DocumentPackageAttributesBuilder(this.apiPackage.getData()).build());
        for (Role role : this.apiPackage.getRoles()) {
            if (role.getSigners().isEmpty()) {
                packageBuilder.withSigner(SignerBuilder.newSignerPlaceholder(new Placeholder(role.getId(), role.getName(), role.getIndex())));
                continue;
            }
            if (role.getSigners().get(0).getGroup() != null) {
                packageBuilder.withSigner(SignerBuilder.newSignerFromGroup(new GroupId(role.getSigners().get(0).getGroup().getId())));
                continue;
            }
            packageBuilder.withSigner(new SignerConverter(role).toSDKSigner());
            if (!"SENDER".equals(role.getType())) continue;
            SenderInfo senderInfo = new SenderInfo();
            com.silanis.esl.api.model.Signer signer = role.getSigners().get(0);
            senderInfo.setFirstName(signer.getFirstName());
            senderInfo.setLastName(signer.getLastName());
            senderInfo.setTitle(signer.getTitle());
            senderInfo.setCompany(signer.getCompany());
            senderInfo.setEmail(signer.getEmail());
            packageBuilder.withSenderInfo(senderInfo);
        }
        for (com.silanis.esl.api.model.Document apiDocument : this.apiPackage.getDocuments()) {
            Document document = new DocumentConverter(apiDocument, this.apiPackage).toSDKDocument();
            packageBuilder.withDocument(document);
        }
        DocumentPackage documentPackage = packageBuilder.build();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (com.silanis.esl.api.model.Message apiMessage : this.apiPackage.getMessages()) {
            messages.add(new MessageConverter(apiMessage).toSDKMessage());
        }
        documentPackage.setMessages(messages);
        if (this.apiPackage.getUpdated() != null) {
            documentPackage.setUpdatedDate(this.apiPackage.getUpdated());
        }
        if (this.apiPackage.getCreated() != null) {
            documentPackage.setCreatedDate(this.apiPackage.getCreated());
        }
        if (this.apiPackage.getConditions() != null) {
            ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
            for (com.silanis.esl.api.model.FieldCondition condition : this.apiPackage.getConditions()) {
                conditions.add(new FieldConditionConverter(condition).toSDKFieldCondition());
            }
            documentPackage.setConditions(conditions);
        }
        return documentPackage;
    }

    private Locale toSdkLanguage(String apiLanguage) {
        if (apiLanguage == null) {
            return null;
        }
        String[] strArray = apiLanguage.split("-");
        if (strArray.length == 2) {
            return new Locale(strArray[0], strArray[1]);
        }
        return new Locale(strArray[0]);
    }
}

