/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.Translation;
import com.silanis.esl.sdk.builder.CustomFieldBuilder;
import com.silanis.esl.sdk.builder.TranslationBuilder;
import java.util.ArrayList;

public class CustomFieldConverter {
    private CustomField sdkCustomField = null;
    private com.silanis.esl.api.model.CustomField apiCustomField = null;

    public CustomFieldConverter(CustomField sdkCustomField) {
        this.sdkCustomField = sdkCustomField;
    }

    public CustomFieldConverter(com.silanis.esl.api.model.CustomField apiCustomField) {
        this.apiCustomField = apiCustomField;
    }

    public com.silanis.esl.api.model.CustomField toAPICustomField() {
        if (this.sdkCustomField == null) {
            return this.apiCustomField;
        }
        com.silanis.esl.api.model.CustomField result = new com.silanis.esl.api.model.CustomField();
        result.safeSetId(this.sdkCustomField.getId());
        result.safeSetValue(this.sdkCustomField.getValue());
        result.safeSetRequired(this.sdkCustomField.getRequired());
        result.safeSetTranslations(Lists.newArrayList(Iterables.transform(this.sdkCustomField.getTranslations(), new Function<Translation, com.silanis.esl.api.model.Translation>(){

            @Override
            public com.silanis.esl.api.model.Translation apply(Translation input) {
                return input.toAPITranslation();
            }
        })));
        return result;
    }

    public CustomField toSDKCustomField() {
        if (this.apiCustomField == null) {
            return this.sdkCustomField;
        }
        ArrayList<Translation> sdkTranslations = Lists.newArrayList(Iterables.transform(this.apiCustomField.getTranslations(), new Function<com.silanis.esl.api.model.Translation, Translation>(){

            @Override
            public Translation apply(com.silanis.esl.api.model.Translation input) {
                return TranslationBuilder.newTranslation(input).build();
            }
        }));
        return CustomFieldBuilder.customFieldWithId(this.apiCustomField.getId()).withDefaultValue(this.apiCustomField.getValue()).withTranslations(sdkTranslations).isRequired(this.apiCustomField.evalRequired()).build();
    }
}

