/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.Company;
import com.silanis.esl.sdk.internal.converter.AddressConverter;
import java.util.Map;

public class CompanyConverter {
    private Optional<com.silanis.esl.api.model.Company> apiCompanyOptional;
    private Optional<Company> sdkCompanyOptional;

    public CompanyConverter(com.silanis.esl.api.model.Company apiCompany) {
        this.apiCompanyOptional = Optional.fromNullable(apiCompany);
        this.sdkCompanyOptional = Optional.absent();
    }

    public CompanyConverter(Company sdkCompany) {
        this.apiCompanyOptional = Optional.absent();
        this.sdkCompanyOptional = Optional.fromNullable(sdkCompany);
    }

    public com.silanis.esl.api.model.Company toAPICompany() {
        if (this.sdkCompanyOptional.isPresent()) {
            com.silanis.esl.api.model.Company apiCompany = new com.silanis.esl.api.model.Company();
            Company sdkCompany = this.sdkCompanyOptional.get();
            if (sdkCompany.getAddress() != null) {
                apiCompany.setAddress(new AddressConverter(sdkCompany.getAddress()).toAPIAddress());
            }
            apiCompany.setId(sdkCompany.getId());
            apiCompany.setName(sdkCompany.getName());
            apiCompany.setData((Map)sdkCompany.getData());
            return apiCompany;
        }
        return this.apiCompanyOptional.orNull();
    }

    public Company toSDKCompany() {
        if (this.apiCompanyOptional.isPresent()) {
            Company sdkCompany = new Company();
            com.silanis.esl.api.model.Company apiCompany = this.apiCompanyOptional.get();
            if (apiCompany.getAddress() != null) {
                sdkCompany.setAddress(new AddressConverter(apiCompany.getAddress()).toSDKAddress());
            }
            sdkCompany.setId(apiCompany.getId());
            sdkCompany.setName(apiCompany.getName());
            sdkCompany.setData(apiCompany.getData());
            return sdkCompany;
        }
        return this.sdkCompanyOptional.orNull();
    }
}

