/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.BrandingBarOptions;
import com.silanis.esl.api.model.GlobalActionsOptions;
import com.silanis.esl.api.model.HeaderOptions;
import com.silanis.esl.api.model.Image;
import com.silanis.esl.api.model.LayoutOptions;
import com.silanis.esl.api.model.TitleBarOptions;
import com.silanis.esl.sdk.CeremonyLayoutSettings;

public class CeremonyLayoutSettingsConverter {
    private CeremonyLayoutSettings sdkCeremonyLayoutSettings = null;
    private LayoutOptions apiLayoutOptions = null;

    public CeremonyLayoutSettingsConverter(CeremonyLayoutSettings sdkCeremonyLayoutSettings) {
        this.sdkCeremonyLayoutSettings = sdkCeremonyLayoutSettings;
    }

    public CeremonyLayoutSettingsConverter(LayoutOptions apiLayoutOptions) {
        this.apiLayoutOptions = apiLayoutOptions;
    }

    public LayoutOptions toAPILayoutOptions() {
        if (this.sdkCeremonyLayoutSettings == null) {
            return this.apiLayoutOptions;
        }
        HeaderOptions headerOptions = new HeaderOptions();
        if (this.sdkCeremonyLayoutSettings.getShowTitle() != null || this.sdkCeremonyLayoutSettings.getProgressBar() != null) {
            TitleBarOptions titleBarOptions = new TitleBarOptions();
            titleBarOptions.safeSetTitle(this.sdkCeremonyLayoutSettings.getShowTitle());
            titleBarOptions.safeSetProgressBar(this.sdkCeremonyLayoutSettings.getProgressBar());
            headerOptions.safeSetTitleBar(titleBarOptions);
        }
        headerOptions.safeSetBreadcrumbs(this.sdkCeremonyLayoutSettings.getBreadCrumbs());
        headerOptions.safeSetSessionBar(this.sdkCeremonyLayoutSettings.getSessionBar());
        headerOptions.safeSetGlobalNavigation(this.sdkCeremonyLayoutSettings.getGlobalNavigation());
        GlobalActionsOptions globalActionsOptions = new GlobalActionsOptions();
        globalActionsOptions.safeSetConfirm(this.sdkCeremonyLayoutSettings.getShowGlobalConfirmButton());
        globalActionsOptions.safeSetDownload(this.sdkCeremonyLayoutSettings.getShowGlobalDownloadButton());
        globalActionsOptions.safeSetSaveAsLayout(this.sdkCeremonyLayoutSettings.getShowGlobalSaveAsLayoutButton());
        headerOptions.setGlobalActions(globalActionsOptions);
        BrandingBarOptions brandingBarOptions = null;
        if (this.sdkCeremonyLayoutSettings.getLogoImageLink() != null || this.sdkCeremonyLayoutSettings.getLogoImageSource() != null) {
            brandingBarOptions = new BrandingBarOptions();
            Image logo = new Image();
            logo.safeSetLink(this.sdkCeremonyLayoutSettings.getLogoImageLink());
            logo.safeSetSrc(this.sdkCeremonyLayoutSettings.getLogoImageSource());
            brandingBarOptions.safeSetLogo(logo);
        }
        LayoutOptions result = new LayoutOptions();
        result.safeSetIframe(this.sdkCeremonyLayoutSettings.getiFrame());
        result.safeSetNavigator(this.sdkCeremonyLayoutSettings.getNavigator());
        result.safeSetHeader(headerOptions);
        result.safeSetBrandingBar(brandingBarOptions);
        return result;
    }

    public CeremonyLayoutSettings toSDKCeremonyLayoutSettings() {
        if (this.apiLayoutOptions == null) {
            return this.sdkCeremonyLayoutSettings;
        }
        CeremonyLayoutSettings result = new CeremonyLayoutSettings();
        result.setiFrame(this.apiLayoutOptions.getIframe());
        if (this.apiLayoutOptions.getHeader() != null) {
            result.setBreadCrumbs(this.apiLayoutOptions.getHeader().getBreadcrumbs());
            result.setSessionBar(this.apiLayoutOptions.getHeader().getSessionBar());
            result.setGlobalNavigation(this.apiLayoutOptions.getHeader().getGlobalNavigation());
            if (this.apiLayoutOptions.getHeader().getGlobalActions() != null) {
                result.setShowGlobalSaveAsLayoutButton(this.apiLayoutOptions.getHeader().getGlobalActions().getSaveAsLayout());
                result.setShowGlobalConfirmButton(this.apiLayoutOptions.getHeader().getGlobalActions().getConfirm());
                result.setShowGlobalDownloadButton(this.apiLayoutOptions.getHeader().getGlobalActions().getDownload());
            }
            if (this.apiLayoutOptions.getHeader().getTitleBar() != null) {
                result.setProgressBar(this.apiLayoutOptions.getHeader().getTitleBar().getProgressBar());
                result.setShowTitle(this.apiLayoutOptions.getHeader().getTitleBar().getTitle());
            }
            result.setNavigator(this.apiLayoutOptions.getNavigator());
            if (this.apiLayoutOptions.getBrandingBar() != null && this.apiLayoutOptions.getBrandingBar().getLogo() != null) {
                result.setLogoImageSource(this.apiLayoutOptions.getBrandingBar().getLogo().getSrc());
                result.setLogoImageLink(this.apiLayoutOptions.getBrandingBar().getLogo().getLink());
            }
        }
        return result;
    }
}

