/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.Address;

public class AddressConverter {
    private Optional<com.silanis.esl.api.model.Address> optionalApiAddress;
    private Optional<Address> optionalSdkAddress;

    public AddressConverter(com.silanis.esl.api.model.Address apiAddress) {
        this.optionalApiAddress = Optional.of(apiAddress);
        this.optionalSdkAddress = Optional.absent();
    }

    public AddressConverter(Address sdkAddress) {
        this.optionalApiAddress = Optional.absent();
        this.optionalSdkAddress = Optional.of(sdkAddress);
    }

    public com.silanis.esl.api.model.Address toAPIAddress() {
        if (this.optionalSdkAddress.isPresent()) {
            com.silanis.esl.api.model.Address result = new com.silanis.esl.api.model.Address();
            result.setAddress1(this.optionalSdkAddress.get().getAddress1());
            result.setAddress2(this.optionalSdkAddress.get().getAddress2());
            result.setCity(this.optionalSdkAddress.get().getCity());
            result.setCountry(this.optionalSdkAddress.get().getCountry());
            result.setState(this.optionalSdkAddress.get().getState());
            result.setZipcode(this.optionalSdkAddress.get().getZipCode());
            return result;
        }
        return this.optionalApiAddress.get();
    }

    public Address toSDKAddress() {
        if (this.optionalApiAddress.isPresent()) {
            Address result = new Address();
            result.setAddress1(this.optionalApiAddress.get().getAddress1());
            result.setAddress2(this.optionalApiAddress.get().getAddress2());
            result.setState(this.optionalApiAddress.get().getState());
            result.setCountry(this.optionalApiAddress.get().getCountry());
            result.setCity(this.optionalApiAddress.get().getCity());
            result.setZipCode(this.optionalApiAddress.get().getZipcode());
            return result;
        }
        return this.optionalSdkAddress.get();
    }
}

