/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.api.model.Sender;
import com.silanis.esl.sdk.AccountMember;
import com.silanis.esl.sdk.internal.converter.AddressConverter;
import com.silanis.esl.sdk.internal.converter.SenderStatusConverter;

public class AccountMemberConverter {
    private Optional<Sender> optionalSender;
    private Optional<AccountMember> optionalAccountMember;

    public AccountMemberConverter(Sender apiSender) {
        this.optionalSender = Optional.of(apiSender);
        this.optionalAccountMember = Optional.absent();
    }

    public AccountMemberConverter(AccountMember sdkAccountMember) {
        this.optionalSender = Optional.absent();
        this.optionalAccountMember = Optional.of(sdkAccountMember);
    }

    public Sender toAPISender() {
        if (this.optionalAccountMember.isPresent()) {
            Sender result = new Sender();
            if (this.optionalAccountMember.get().getAddress() != null) {
                result.setAddress(new AddressConverter(this.optionalAccountMember.get().getAddress()).toAPIAddress());
            }
            result.setCompany(this.optionalAccountMember.get().getCompany());
            result.setEmail(this.optionalAccountMember.get().getEmail());
            result.setFirstName(this.optionalAccountMember.get().getFirstName());
            result.setLastName(this.optionalAccountMember.get().getLastName());
            result.setTitle(this.optionalAccountMember.get().getTitle());
            result.setLanguage(this.optionalAccountMember.get().getLanguage());
            result.setPhone(this.optionalAccountMember.get().getPhoneNumber());
            if (this.optionalAccountMember.get().getTimezoneId() != null) {
                result.setTimezoneId(this.optionalAccountMember.get().getTimezoneId());
            }
            if (this.optionalAccountMember.get().getStatus().isPresent()) {
                result.setStatus(new SenderStatusConverter(this.optionalAccountMember.get().getStatus().get()).toAPISenderStatus());
            }
            return result;
        }
        return this.optionalSender.get();
    }

    public AccountMember toSDKAccountMember() {
        if (this.optionalSender.isPresent()) {
            AccountMember result = new AccountMember();
            if (this.optionalSender.get().getAddress() != null) {
                result.setAddress(new AddressConverter(this.optionalSender.get().getAddress()).toSDKAddress());
            }
            result.setCompany(this.optionalSender.get().getCompany());
            result.setEmail(this.optionalSender.get().getEmail());
            result.setFirstName(this.optionalSender.get().getFirstName());
            result.setLastName(this.optionalSender.get().getLastName());
            result.setTitle(this.optionalSender.get().getTitle());
            result.setLanguage(this.optionalSender.get().getLanguage());
            result.setPhoneNumber(this.optionalSender.get().getPhone());
            result.setTimezoneId(this.optionalSender.get().getTimezoneId());
            result.setStatus(new SenderStatusConverter(this.optionalSender.get().getStatus()).toSDKSenderStatus());
            return result;
        }
        return this.optionalAccountMember.get();
    }
}

