/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.Account;
import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.License;
import com.silanis.esl.sdk.internal.converter.AccountProvidersConverter;
import com.silanis.esl.sdk.internal.converter.CompanyConverter;
import com.silanis.esl.sdk.internal.converter.CustomFieldConverter;
import com.silanis.esl.sdk.internal.converter.LicenseConverter;
import java.util.Map;

public class AccountConverter {
    private Optional<com.silanis.esl.api.model.Account> apiAccountOptional;
    private Optional<Account> sdkAccountOptional;

    public AccountConverter(com.silanis.esl.api.model.Account apiAccount) {
        this.apiAccountOptional = Optional.fromNullable(apiAccount);
        this.sdkAccountOptional = Optional.absent();
    }

    public AccountConverter(Account sdkAccount) {
        this.apiAccountOptional = Optional.absent();
        this.sdkAccountOptional = Optional.fromNullable(sdkAccount);
    }

    public com.silanis.esl.api.model.Account toAPIAccount() {
        if (this.sdkAccountOptional.isPresent()) {
            com.silanis.esl.api.model.Account apiAccount = new com.silanis.esl.api.model.Account();
            Account sdkAccount = this.sdkAccountOptional.get();
            apiAccount.setId(sdkAccount.getId());
            apiAccount.setName(sdkAccount.getName());
            apiAccount.setOwner(sdkAccount.getOwner());
            apiAccount.setCreated(sdkAccount.getCreated());
            apiAccount.setUpdated(sdkAccount.getUpdated());
            apiAccount.setLogoUrl(sdkAccount.getLogoUrl());
            apiAccount.setData((Map)sdkAccount.getData());
            if (sdkAccount.getCompany() != null) {
                apiAccount.setCompany(new CompanyConverter(sdkAccount.getCompany()).toAPICompany());
            }
            if (sdkAccount.getProviders() != null) {
                apiAccount.setProviders(new AccountProvidersConverter(sdkAccount.getProviders()).toAPIAccountProviders());
            }
            for (CustomField customField : sdkAccount.getCustomFields()) {
                apiAccount.addCustomField(new CustomFieldConverter(customField).toAPICustomField());
            }
            for (License license : sdkAccount.getLicenses()) {
                apiAccount.addLicense(new LicenseConverter(license).toAPILicense());
            }
            return apiAccount;
        }
        return this.apiAccountOptional.orNull();
    }

    public Account toSDKAccount() {
        if (this.apiAccountOptional.isPresent()) {
            Account sdkAccount = new Account();
            com.silanis.esl.api.model.Account apiAccount = this.apiAccountOptional.get();
            sdkAccount.setId(apiAccount.getId());
            sdkAccount.setName(apiAccount.getName());
            sdkAccount.setOwner(apiAccount.getOwner());
            sdkAccount.setData(apiAccount.getData());
            sdkAccount.setLogoUrl(apiAccount.getLogoUrl());
            sdkAccount.setCreated(apiAccount.getCreated());
            sdkAccount.setUpdated(apiAccount.getUpdated());
            if (apiAccount.getCompany() != null) {
                sdkAccount.setCompany(new CompanyConverter(apiAccount.getCompany()).toSDKCompany());
            }
            if (apiAccount.getProviders() != null) {
                sdkAccount.setProviders(new AccountProvidersConverter(apiAccount.getProviders()).toSDKAccountProviders());
            }
            for (com.silanis.esl.api.model.CustomField customField : apiAccount.getCustomFields()) {
                sdkAccount.addCustomField(new CustomFieldConverter(customField).toSDKCustomField());
            }
            for (com.silanis.esl.api.model.License license : apiAccount.getLicenses()) {
                sdkAccount.addLicense(new LicenseConverter(license).toSDKLicense());
            }
            return sdkAccount;
        }
        return this.sdkAccountOptional.orNull();
    }
}

