/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.silanis.esl.api.model.Error;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.Support;
import java.util.ArrayList;
import java.util.List;

public class Serialization {
    private static final Support support = new Support();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object object) {
        return JacksonUtil.serializeDirty(object);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            Error errorMessage = JacksonUtil.deserialize(json, Error.class);
            support.logError(errorMessage);
            throw new EslException(json);
        }
    }

    public static <T> List<T> fromJsonToList(String json, Class<T> clazz) {
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz));
        }
        catch (JsonMappingException me) {
            ArrayList<T> obj = new ArrayList<T>();
            obj.add(Serialization.fromJson(json, clazz));
            return obj;
        }
        catch (Exception e) {
            Error errorMessage = JacksonUtil.deserialize(json, Error.class);
            support.logError(errorMessage);
            throw new EslException(json);
        }
    }
}

