/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.silanis.esl.sdk.internal.AuthRequestParameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpRequestUtil {
    public static final String SESSION_TOKEN_COOKIE_VALUE_KEY = "ESIGNLIVE_SESSION_ID";
    public static final String TEMP_SESSION_TOKEN_COOKIE_VALUE_KEY = "ESIGNLIVE_TEMP_TOKEN";
    public static final String SESSION_TOKEN_COOKIE_KEY = "Cookie";
    public static final String API_KEY_AUTHENTICATION_AUTHORIZATION_KEY = "Authorization";
    public static final String API_KEY_AUTHENTICATION_BASIC_PREFIX = "Basic ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getUrlContent(String requestedURL) {
        String urlContent;
        block7: {
            urlContent = "";
            InputStream is = null;
            try {
                URL url = new URL(requestedURL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setInstanceFollowRedirects(false);
                String location = conn.getHeaderField("Location");
                String cookieSessionToken = HttpRequestUtil.extractSessionCookieValue(conn);
                String cookieTempTokenValue = HttpRequestUtil.extractTempTokenCookieValue(conn);
                URL redirectURL = new URL(location);
                HttpURLConnection redirectRequest = (HttpURLConnection)redirectURL.openConnection();
                HttpRequestUtil.setAuthentication(redirectRequest, AuthRequestParameters.empty());
                redirectRequest.setRequestProperty(SESSION_TOKEN_COOKIE_KEY, HttpRequestUtil.buildSessionTokenCookieValue(cookieSessionToken) + ";" + HttpRequestUtil.buildTempTokenCookieValue(cookieTempTokenValue));
                is = redirectRequest.getInputStream();
                urlContent = IOUtils.toString(new BufferedReader(new InputStreamReader(is)));
                IOUtils.closeQuietly(is);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        return urlContent;
    }

    private static void setAuthentication(HttpURLConnection request, AuthRequestParameters authRequestParameters) {
        if (authRequestParameters.hasSessionToken()) {
            request.addRequestProperty(SESSION_TOKEN_COOKIE_KEY, HttpRequestUtil.buildSessionTokenCookieValue(authRequestParameters.getSessionToken()));
        } else if (authRequestParameters.hasApiKey()) {
            request.addRequestProperty(API_KEY_AUTHENTICATION_AUTHORIZATION_KEY, API_KEY_AUTHENTICATION_BASIC_PREFIX + authRequestParameters.getApiKey());
        } else if (authRequestParameters.hasTempToken()) {
            request.addRequestProperty(SESSION_TOKEN_COOKIE_KEY, HttpRequestUtil.buildTempTokenCookieValue(authRequestParameters.getTempToken()));
        } else if (authRequestParameters.hasConnectorsAuth()) {
            request.addRequestProperty(API_KEY_AUTHENTICATION_AUTHORIZATION_KEY, API_KEY_AUTHENTICATION_BASIC_PREFIX + authRequestParameters.getConnectorsAuth());
        }
    }

    private static String buildSessionTokenCookieValue(String sessionTokenValue) {
        return "ESIGNLIVE_SESSION_ID=" + sessionTokenValue;
    }

    private static String buildTempTokenCookieValue(String sessionTokenValue) {
        return "ESIGNLIVE_TEMP_TOKEN=" + sessionTokenValue;
    }

    private static String extractSessionCookieValue(HttpURLConnection request) {
        return HttpRequestUtil.extractSessionCookieValue(request, SESSION_TOKEN_COOKIE_VALUE_KEY);
    }

    private static String extractTempTokenCookieValue(HttpURLConnection request) {
        return HttpRequestUtil.extractSessionCookieValue(request, TEMP_SESSION_TOKEN_COOKIE_VALUE_KEY);
    }

    private static String extractSessionCookieValue(HttpURLConnection request, String sessionKeyString) {
        String setCookieValue = request.getHeaderField("Set-Cookie");
        if (StringUtils.isNotEmpty(setCookieValue) && StringUtils.contains((CharSequence)setCookieValue, sessionKeyString) && HttpRequestUtil.hasCookieValue(setCookieValue, sessionKeyString)) {
            String SESSION_ID_KEY_WITH_EQUAL = sessionKeyString + "=";
            int startOfSessionIdValue = setCookieValue.indexOf(SESSION_ID_KEY_WITH_EQUAL) + SESSION_ID_KEY_WITH_EQUAL.length();
            String endOfCookieValue = setCookieValue.substring(startOfSessionIdValue);
            int endOfSessionIdValue = endOfCookieValue.indexOf(";");
            return endOfCookieValue.substring(0, endOfSessionIdValue);
        }
        return "";
    }

    private static boolean hasCookieValue(String setCookieValue, String sessionKeyString) {
        return StringUtils.isNotBlank(StringUtils.remove(StringUtils.remove(setCookieValue, sessionKeyString), '='));
    }
}

