/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;

public class SignerManipulationExample
extends SDKSample {
    public DocumentPackage createdPackage;
    public DocumentPackage createdPackageWithAddedSigner;
    public DocumentPackage createdPackageWithRemovedSigner;
    public DocumentPackage createdPackageWithUpdatedSigner;
    public Signer updatedSigner;

    public static void main(String ... args) {
        new SignerManipulationExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("firstName1").withLastName("lastName1").withTitle("Title1")).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName("firstName2").withLastName("lastName2").withTitle("Title2")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(500.0, 100.0)).withSignature(SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(500.0, 500.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.createdPackage = this.eslClient.getPackage(this.packageId);
        String signerId = this.createdPackage.getSigner(this.email1).getId();
        String signer2Id = this.createdPackage.getSigner(this.email2).getId();
        String addedSignerId = this.eslClient.getPackageService().addSigner(this.packageId, SignerBuilder.newSignerWithEmail(this.email3).withFirstName("firstName3").withLastName("lastName3").withTitle("Title3").build());
        this.createdPackageWithAddedSigner = this.eslClient.getPackage(this.packageId);
        this.eslClient.getPackageService().removeSigner(this.packageId, signerId);
        this.createdPackageWithRemovedSigner = this.eslClient.getPackage(this.packageId);
        this.eslClient.getPackageService().updateSigner(this.packageId, SignerBuilder.newSignerWithEmail("timbob@aol.com").withCustomId(signer2Id).withFirstName("updateFirstName1").withLastName("updateLastName1").withTitle("updateTitle1").build());
        this.updatedSigner = this.eslClient.getPackageService().getSigner(this.packageId, signer2Id);
        this.eslClient.getPackageService().unlockSigner(this.packageId, addedSignerId);
        this.createdPackageWithUpdatedSigner = this.eslClient.getPackage(this.packageId);
        this.eslClient.sendPackage(this.packageId);
    }
}

