/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.IdvWorkflowConfig;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.IdvWorkflowBuilder;
import com.silanis.esl.sdk.builder.IdvWorkflowConfigBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import com.silanis.esl.sdk.service.AccountConfigService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IdvAuthExample
extends SDKSample {
    public static final String PHONE_NUMBER = "+15555555555";
    public static final String IDV_WORKFLOW_ID1 = "00000000-0000-0001-0000-200000000055";
    public static final String TYPE1 = "DV";
    public static final String TENANT = "oss";
    public static final String DESC1 = "This is Mitek Document verification only Mock workflow.";
    public static final String IDV_WORKFLOW_ID2 = "00000000-0001-0001-0000-200000000055";
    public static final String TYPE2 = "DVF";
    public static final String DESC2 = "This is Mitek Document Verification with Facial Comparison Mock workflow.";
    public List<IdvWorkflowConfig> idvWorkflowConfigsBeforeCreating;
    public List<IdvWorkflowConfig> idvWorkflowConfigsAfterCreating;
    public List<IdvWorkflowConfig> idvWorkflowConfigsAfterUpdating;
    public List<IdvWorkflowConfig> idvWorkflowConfigsAfterDeleting;

    public static void main(String ... args) {
        new IdvAuthExample().run();
    }

    @Override
    public void execute() {
        AccountConfigService accountConfigService = this.eslClient.getAccountConfigService();
        this.idvWorkflowConfigsBeforeCreating = accountConfigService.getIdvWorkflowConfigs();
        if (!this.idvWorkflowConfigsBeforeCreating.isEmpty()) {
            accountConfigService.deleteIdvWorkflowConfigs();
            this.idvWorkflowConfigsBeforeCreating = accountConfigService.getIdvWorkflowConfigs();
        }
        this.idvWorkflowConfigsAfterCreating = accountConfigService.createIdvWorkflowConfigs(Collections.singletonList(IdvWorkflowConfigBuilder.newIdvWorkflowConfig(IDV_WORKFLOW_ID1).withType(TYPE1).withTenant(TENANT).withDesc(DESC1).enableSkipWhenAccessingSignedDocuments().build()));
        this.idvWorkflowConfigsAfterUpdating = accountConfigService.updateIdvWorkflowConfigs(Arrays.asList(IdvWorkflowConfigBuilder.newIdvWorkflowConfig(IDV_WORKFLOW_ID1).withType(TYPE1).withTenant(TENANT).withDesc(DESC1).enableSkipWhenAccessingSignedDocuments().build(), IdvWorkflowConfigBuilder.newIdvWorkflowConfig(IDV_WORKFLOW_ID2).withType(TYPE2).withTenant(TENANT).withDesc(DESC2).enableSkipWhenAccessingSignedDocuments().build()));
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a Signer IDV authentication example").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("Jamie Anne").withLastName("Kurtz").withIDVAuthentication(PHONE_NUMBER, IdvWorkflowBuilder.newIdvWorkflow(IDV_WORKFLOW_ID1).withType(TYPE1).withTenant(TENANT).build())).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        accountConfigService.deleteIdvWorkflowConfigs();
        this.idvWorkflowConfigsAfterDeleting = accountConfigService.getIdvWorkflowConfigs();
    }
}

