/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.External;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.ArrayList;
import org.joda.time.DateMidnight;

public class ExternalDocumentExample
extends SDKSample {
    public static void main(String ... args) {
        new ExternalDocumentExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage packageWithExternalContent = PackageBuilder.newPackageNamed(this.getPackageName()).expiresAt(DateMidnight.now().plusMonths(1).toDate()).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(packageWithExternalContent);
        ArrayList<Document> externalDocuments = new ArrayList<Document>();
        External external = new External("vfs", "/test/completed/files/test", "");
        Document ftpDocument = new Document();
        ftpDocument.setName("FTP Document");
        ftpDocument.setDescription("Test FTP document");
        ftpDocument.setExternal(external);
        externalDocuments.add(ftpDocument);
        this.eslClient.getPackageService().addDocumentWithExternalContent(this.packageId.getId(), externalDocuments);
        this.eslClient.sendPackage(this.packageId);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
    }
}

