/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Audit;
import com.silanis.esl.sdk.EslClient;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.io.Files;
import java.util.List;
import java.util.Properties;

public class DownloadDocumentsEvidenceAndAuditExample {
    private static final Properties props = Props.get();
    public static final String API_KEY = props.getProperty("api.key");
    public static final String API_URL = props.getProperty("api.url");

    public static void main(String ... args) {
        EslClient esl = new EslClient(API_KEY, API_URL);
        PackageId packageId = new PackageId("8d086f61-09b6-4da1-a385-b12eb3ac3654");
        byte[] downloadDocument = esl.downloadDocument(packageId, "2579a8b01f0e008e");
        Files.saveTo(downloadDocument, "download/downloaded.pdf");
        byte[] evidenceContent = esl.downloadEvidenceSummary(packageId);
        Files.saveTo(evidenceContent, "download/evidence.pdf");
        byte[] zip = esl.downloadZippedDocuments(packageId);
        Files.saveTo(zip, "download/package.zip");
        List<Audit> auditList = esl.getAuditService().getAudit(packageId);
        System.out.println();
    }
}

